/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.application.IComponentInstantiationListener;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.injection.annot.AnnotProxyFieldValueFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentInjector
extends Injector
implements IComponentInstantiationListener {
    private final IFieldValueFactory fieldValueFactory;
    private static MetaDataKey<ApplicationContext> CONTEXT_KEY = new MetaDataKey<ApplicationContext>(){
        private static final long serialVersionUID = 1L;
    };

    public SpringComponentInjector(WebApplication webapp) {
        this(webapp, (ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webapp.getServletContext()));
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx) {
        this(webapp, ctx, true);
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx, boolean wrapInProxies) {
        if (webapp == null) {
            throw new IllegalArgumentException("Argument [[webapp]] cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("Argument [[ctx]] cannot be null");
        }
        webapp.setMetaData(CONTEXT_KEY, (Object)ctx);
        this.fieldValueFactory = new AnnotProxyFieldValueFactory(new ContextLocator(), wrapInProxies);
        this.bind((Application)webapp);
    }

    public void inject(Object object) {
        this.inject(object, this.fieldValueFactory);
    }

    public void onInstantiation(Component component) {
        this.inject(component);
    }

    private static class ContextLocator
    implements ISpringContextLocator {
        private transient ApplicationContext context;
        private static final long serialVersionUID = 1L;

        private ContextLocator() {
        }

        public ApplicationContext getSpringContext() {
            if (this.context == null) {
                this.context = (ApplicationContext)Application.get().getMetaData(CONTEXT_KEY);
            }
            return this.context;
        }
    }
}

