/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private final ISpringContextLocator contextLocator;
    private final ConcurrentHashMap<SpringBeanLocator, Object> cache = Generics.newConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, String> beanNameCache = Generics.newConcurrentHashMap();
    private final boolean wrapInProxies;

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        this(contextLocator, true);
    }

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator, boolean wrapInProxies) {
        if (contextLocator == null) {
            throw new IllegalArgumentException("[contextLocator] argument cannot be null");
        }
        this.contextLocator = contextLocator;
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (field.isAnnotationPresent(SpringBean.class)) {
            SpringBeanLocator locator = new SpringBeanLocator(this.getBeanName(field), field.getType(), this.contextLocator);
            if (this.cache.containsKey(locator)) {
                return this.cache.get(locator);
            }
            Object target = this.wrapInProxies ? LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator) : locator.locateProxyTarget();
            if (locator.isSingletonBean()) {
                this.cache.put(locator, target);
            }
            return target;
        }
        return null;
    }

    private String getBeanName(Field field) {
        SpringBean annot = field.getAnnotation(SpringBean.class);
        String name = annot.name();
        if (Strings.isEmpty((CharSequence)name) && (name = this.beanNameCache.get(field.getType())) == null) {
            name = this.getBeanNameOfClass(this.contextLocator.getSpringContext(), field.getType());
            this.beanNameCache.put(field.getType(), name);
        }
        return name;
    }

    private final String getBeanNameOfClass(ApplicationContext ctx, Class<?> clazz) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)ctx, clazz)));
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String possibility = (String)it.next();
            if (!BeanFactoryUtils.isFactoryDereference((String)possibility) && !possibility.startsWith("scopedTarget.")) continue;
            it.remove();
        }
        if (names.isEmpty()) {
            throw new IllegalStateException("bean of type [" + clazz.getName() + "] not found");
        }
        if (names.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("more then one bean of type [");
            msg.append(clazz.getName());
            msg.append("] found, you have to specify the name of the bean ");
            msg.append("(@SpringBean(name=\"foo\")) in order to resolve this conflict. ");
            msg.append("Matched beans: ");
            msg.append(Strings.join((String)",", (String[])names.toArray(new String[0])));
            throw new IllegalStateException(msg.toString());
        }
        return (String)names.get(0);
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class);
    }
}

