/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import java.lang.ref.WeakReference;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<Class<?>> beanTypeCache;
    private final String beanTypeName;
    private String beanName;
    private ISpringContextLocator springContextLocator;
    private Boolean singletonCache = null;

    public SpringBeanLocator(Class<?> beanType, ISpringContextLocator locator) {
        this(null, beanType, locator);
    }

    public SpringBeanLocator(String beanName, Class<?> beanType, ISpringContextLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException("[locator] argument cannot be null");
        }
        if (beanType == null) {
            throw new IllegalArgumentException("[beanType] argument cannot be null");
        }
        this.beanTypeCache = new WeakReference(beanType);
        this.beanTypeName = beanType.getName();
        this.springContextLocator = locator;
        this.beanName = beanName;
        this.springContextLocator = locator;
    }

    private final String getBeanNameOfClass(ApplicationContext ctx, Class<?> clazz) {
        String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)ctx, clazz);
        if (names.length == 0) {
            throw new IllegalStateException("bean of type [" + clazz.getName() + "] not found");
        }
        if (names.length > 1) {
            StringBuffer msg = new StringBuffer();
            msg.append("more then one bean of type [");
            msg.append(clazz.getName());
            msg.append("] found, you have to specify the name of the bean ");
            msg.append("(@SpringBean(name=\"foo\")) in order to resolve this conflict. ");
            msg.append("Matched beans: ");
            msg.append(Strings.join((String)",", (String[])names));
            throw new IllegalStateException(msg.toString());
        }
        return names[0];
    }

    public boolean isSingletonBean() {
        if (this.singletonCache == null) {
            this.singletonCache = this.getSpringContext().isSingleton(this.getBeanName());
        }
        return this.singletonCache;
    }

    public Class<?> getBeanType() {
        Class clazz;
        Class clazz2 = clazz = this.beanTypeCache == null ? null : (Class)this.beanTypeCache.get();
        if (clazz == null) {
            clazz = Classes.resolveClass((String)this.beanTypeName);
            this.beanTypeCache = new WeakReference<Class>(clazz);
            if (clazz == null) {
                throw new RuntimeException("SpringBeanLocator could not find class [" + this.beanTypeName + "] needed to locate the [" + (this.beanName != null ? this.beanName : "bean name not specified") + "] bean");
            }
        }
        return clazz;
    }

    public Object locateProxyTarget() {
        ApplicationContext context = this.getSpringContext();
        if (this.beanName != null && this.beanName.length() > 0) {
            return SpringBeanLocator.lookupSpringBean(context, this.beanName, this.getBeanType());
        }
        return this.lookupSpringBean(context, this.getBeanType());
    }

    private ApplicationContext getSpringContext() {
        ApplicationContext context = this.springContextLocator.getSpringContext();
        if (context == null) {
            throw new IllegalStateException("spring application context locator returned null");
        }
        return context;
    }

    public final String getBeanName() {
        if (this.beanName == null || "".equals(this.beanName)) {
            this.beanName = this.getBeanNameOfClass(this.getSpringContext(), this.getBeanType());
        }
        return this.beanName;
    }

    public final ISpringContextLocator getSpringContextLocator() {
        return this.springContextLocator;
    }

    private final Object lookupSpringBean(ApplicationContext ctx, Class<?> clazz) {
        return SpringBeanLocator.lookupSpringBean(ctx, this.getBeanNameOfClass(ctx, clazz), clazz);
    }

    private static Object lookupSpringBean(ApplicationContext ctx, String name, Class<?> clazz) {
        try {
            return ctx.getBean(name, clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("bean with name [" + name + "] and class [" + clazz.getName() + "] not found");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpringBeanLocator) {
            SpringBeanLocator other = (SpringBeanLocator)obj;
            return this.beanTypeName.equals(other.beanTypeName) && Objects.equal((Object)this.beanName, (Object)other.beanName);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.beanTypeName.hashCode();
        if (this.beanName != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }
}

