/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundRequestMapper
implements ICompoundRequestMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundRequestMapper.class);
    private final List<IRequestMapper> mappers = new CopyOnWriteArrayList<IRequestMapper>();

    @Override
    public CompoundRequestMapper add(IRequestMapper mapper) {
        this.mappers.add(0, mapper);
        return this;
    }

    @Override
    public CompoundRequestMapper remove(IRequestMapper mapper) {
        this.mappers.remove(mapper);
        return this;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        ArrayList<MapperWithScore> list = new ArrayList<MapperWithScore>(this.mappers.size());
        for (IRequestMapper mapper : this.mappers) {
            int score = mapper.getCompatibilityScore(request);
            list.add(new MapperWithScore(mapper, score));
        }
        Collections.sort(list);
        if (LOG.isDebugEnabled()) {
            this.logMappers(list, request.getUrl().toString());
        }
        for (MapperWithScore mapperWithScore : list) {
            IRequestMapper mapper = mapperWithScore.getMapper();
            IRequestHandler handler = mapper.mapRequest(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private void logMappers(List<MapperWithScore> mappersWithScores, String url) {
        ArrayList<MapperWithScore> compatibleMappers = new ArrayList<MapperWithScore>();
        for (MapperWithScore mapperWithScore : mappersWithScores) {
            if (mapperWithScore.compatibilityScore <= 0) continue;
            compatibleMappers.add(mapperWithScore);
        }
        if (compatibleMappers.size() == 0) {
            LOG.debug("No compatible mapper found for URL '{}'", (Object)url);
        } else if (compatibleMappers.size() == 1) {
            LOG.debug("One compatible mapper found for URL '{}' -> '{}'", (Object)url, compatibleMappers.get(0));
        } else {
            LOG.debug("Multiple compatible mappers found for URL '{}'", (Object)url);
            for (MapperWithScore compatibleMapper : compatibleMappers) {
                LOG.debug(" * {}", (Object)compatibleMapper);
            }
        }
    }

    @Override
    public Url mapHandler(IRequestHandler handler) {
        for (IRequestMapper mapper : this.mappers) {
            Url url = mapper.mapHandler(handler);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = Integer.MIN_VALUE;
        for (IRequestMapper mapper : this.mappers) {
            score = Math.max(score, mapper.getCompatibilityScore(request));
        }
        return score;
    }

    @Override
    public Iterator<IRequestMapper> iterator() {
        return this.mappers.iterator();
    }

    static class MapperWithScore
    implements Comparable<MapperWithScore> {
        private final IRequestMapper mapper;
        private final int compatibilityScore;

        public MapperWithScore(IRequestMapper mapper, int compatibilityScore) {
            this.mapper = mapper;
            this.compatibilityScore = compatibilityScore;
        }

        @Override
        public int compareTo(MapperWithScore o) {
            return this.compatibilityScore < o.compatibilityScore ? 1 : (this.compatibilityScore > o.compatibilityScore ? -1 : 0);
        }

        public IRequestMapper getMapper() {
            return this.mapper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MapperWithScore)) {
                return false;
            }
            MapperWithScore that = (MapperWithScore)o;
            if (this.compatibilityScore != that.compatibilityScore) {
                return false;
            }
            return this.mapper.equals(that.mapper);
        }

        public int hashCode() {
            int result = this.mapper.hashCode();
            result = 31 * result + this.compatibilityScore;
            return result;
        }

        public String toString() {
            return "Mapper: " + this.mapper.getClass().getName() + "; Score: " + this.compatibilityScore;
        }
    }
}

