/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.Strings;

public class UrlRenderer {
    private static final Map<String, Integer> PROTO_TO_PORT = new HashMap<String, Integer>();
    private final Request request;
    private Url baseUrl;

    public UrlRenderer(Request request) {
        this.request = request;
        this.baseUrl = request.getClientUrl();
    }

    public Url setBaseUrl(Url base) {
        Args.notNull((Object)base, (String)"base");
        Url original = this.baseUrl;
        this.baseUrl = base;
        return original;
    }

    public Url getBaseUrl() {
        return this.baseUrl;
    }

    public String renderUrl(Url url) {
        if (this.shouldRenderAsFull(url)) {
            return this.renderFullUrl(url);
        }
        return this.renderRelativeUrl(url);
    }

    public String renderFullUrl(Url url) {
        String protocol = this.resolveProtocol(url);
        String host = this.resolveHost(url);
        Integer port = this.resolvePort(url);
        String path = url.toString();
        StringBuilder render = new StringBuilder();
        render.append(protocol);
        render.append("://");
        render.append(host);
        if (port != null && !port.equals(PROTO_TO_PORT.get(protocol))) {
            render.append(':');
            render.append(port);
        }
        render.append(this.request.getContextPath());
        render.append(this.request.getFilterPath());
        return Strings.join((String)"/", (String[])new String[]{render.toString(), path});
    }

    protected Integer resolvePort(Url url) {
        return UrlRenderer.choose(url.getPort(), this.baseUrl.getPort(), this.request.getClientUrl().getPort());
    }

    protected String resolveHost(Url url) {
        return UrlRenderer.choose(url.getHost(), this.baseUrl.getHost(), this.request.getClientUrl().getHost());
    }

    protected String resolveProtocol(Url url) {
        return UrlRenderer.choose(url.getProtocol(), this.baseUrl.getProtocol(), this.request.getClientUrl().getProtocol());
    }

    public String renderRelativeUrl(Url url) {
        int baseUrlSize;
        Args.notNull((Object)url, (String)"url");
        if (url.isAbsolute()) {
            return url.toString();
        }
        List<String> baseUrlSegments = this.getBaseUrl().getSegments();
        ArrayList<String> urlSegments = new ArrayList<String>(url.getSegments());
        ArrayList<String> newSegments = new ArrayList<String>();
        int common = 0;
        String last = null;
        for (String s : baseUrlSegments) {
            if (urlSegments.isEmpty() || !s.equals(urlSegments.get(0))) break;
            ++common;
            last = (String)urlSegments.remove(0);
        }
        if (last != null && (urlSegments.isEmpty() || baseUrlSegments.size() == common)) {
            --common;
            urlSegments.add(0, last);
        }
        if (common + 1 == (baseUrlSize = baseUrlSegments.size()) && urlSegments.isEmpty()) {
            newSegments.add(".");
        } else {
            for (int i = common + 1; i < baseUrlSize; ++i) {
                newSegments.add("..");
            }
        }
        newSegments.addAll(urlSegments);
        String renderedUrl = new Url(newSegments, url.getQueryParameters()).toString();
        String result = Strings.isEmpty((CharSequence)renderedUrl) ? "." : (renderedUrl.endsWith("..") ? renderedUrl + '/' : renderedUrl);
        return result;
    }

    protected boolean shouldRenderAsFull(Url url) {
        Url clientUrl = this.request.getClientUrl();
        if (!Strings.isEmpty((CharSequence)url.getProtocol()) && !url.getProtocol().equals(clientUrl.getProtocol())) {
            return true;
        }
        if (!Strings.isEmpty((CharSequence)url.getHost()) && !url.getHost().equals(clientUrl.getHost())) {
            return true;
        }
        return url.getPort() != null && !url.getPort().equals(clientUrl.getPort());
    }

    public String renderContextRelativeUrl(String url) {
        Args.notNull((Object)url, (String)"url");
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        PrependingStringBuffer buffer = new PrependingStringBuffer(url);
        for (int i = 0; i < this.getBaseUrl().getSegments().size() - 1; ++i) {
            buffer.prepend("../");
        }
        buffer.prepend(this.request.getPrefixToContextPath());
        return buffer.toString();
    }

    @Deprecated
    public String renderContextPathRelativeUrl(String url) {
        return this.renderContextRelativeUrl(url);
    }

    private static String choose(String value, String fallback1, String fallback2) {
        if (Strings.isEmpty((CharSequence)value) && Strings.isEmpty((CharSequence)(value = fallback1))) {
            value = fallback2;
        }
        return value;
    }

    private static Integer choose(Integer value, Integer fallback1, Integer fallback2) {
        if (value == null && (value = fallback1) == null) {
            value = fallback2;
        }
        return value;
    }

    static {
        PROTO_TO_PORT.put("http", 80);
        PROTO_TO_PORT.put("https", 443);
    }
}

