/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http.handler;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.junit.Test;
import org.mockito.Mockito;

public class RedirectRequestHandlerTest {
    private static final String REDIRECT_URL = "redirectUrl";

    @Test
    public void permenanentlyMovedShouldSetLocationHeader() {
        RedirectRequestHandler handler = new RedirectRequestHandler(REDIRECT_URL, 301);
        IRequestCycle requestCycle = (IRequestCycle)Mockito.mock(IRequestCycle.class);
        WebResponse webResponse = (WebResponse)Mockito.mock(WebResponse.class);
        Mockito.when((Object)requestCycle.getResponse()).thenReturn((Object)webResponse);
        handler.respond(requestCycle);
        ((WebResponse)Mockito.verify((Object)webResponse)).setStatus(301);
        ((WebResponse)Mockito.verify((Object)webResponse)).setHeader("Location", REDIRECT_URL);
    }

    @Test
    public void tempMovedShouldRedirect() {
        RedirectRequestHandler handler = new RedirectRequestHandler(REDIRECT_URL, 302);
        IRequestCycle requestCycle = (IRequestCycle)Mockito.mock(IRequestCycle.class);
        WebResponse webResponse = (WebResponse)Mockito.mock(WebResponse.class);
        Mockito.when((Object)requestCycle.getResponse()).thenReturn((Object)webResponse);
        handler.respond(requestCycle);
        ((WebResponse)Mockito.verify((Object)webResponse)).sendRedirect(REDIRECT_URL);
    }
}

