/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.wicket.request.Url;

public class UrlTest
extends TestCase {
    private void checkSegments(Url url, String ... segments) {
        UrlTest.assertEquals(Arrays.asList(segments), (Object)url.getSegments());
    }

    private void checkQueryParams(Url url, String ... params) {
        ArrayList<Url.QueryParameter> list = new ArrayList<Url.QueryParameter>();
        for (int i = 0; i < params.length; i += 2) {
            Url.QueryParameter p = new Url.QueryParameter(params[i], params[i + 1]);
            list.add(p);
        }
        UrlTest.assertEquals(list, (Object)url.getQueryParameters());
    }

    public void testParse1() {
        String s = "foo/bar/baz?a=4&b=5";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "foo", "bar", "baz");
        this.checkQueryParams(url, "a", "4", "b", "5");
    }

    public void testParse2() {
        String s = "foo/bar//baz?=4&6";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "foo", "bar", "", "baz");
        this.checkQueryParams(url, "", "4", "6", "");
    }

    public void testParse3() {
        String s = "//foo/bar/";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "", "", "foo", "bar", "");
        this.checkQueryParams(url, new String[0]);
    }

    public void testParse4() {
        String s = "/foo/bar//";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "", "foo", "bar", "", "");
        this.checkQueryParams(url, new String[0]);
    }

    public void testParse5() {
        String s = "foo/b%3Dr/b%26z/x%3F?a=b&x%3F%264=y%3Dz";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "foo", "b=r", "b&z", "x?");
        this.checkQueryParams(url, "a", "b", "x?&4", "y=z");
    }

    public void testParse6() {
        String s = "";
        Url url = Url.parse((String)s);
        this.checkSegments(url, new String[0]);
        this.checkQueryParams(url, new String[0]);
    }

    public void testParse7() {
        String s = "?a=b";
        Url url = Url.parse((String)s);
        this.checkSegments(url, new String[0]);
        this.checkQueryParams(url, "a", "b");
    }

    public void testParse8() {
        String s = "/";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "", "");
        this.checkQueryParams(url, new String[0]);
    }

    public void testParse9() {
        String s = "/?a=b";
        Url url = Url.parse((String)s);
        this.checkSegments(url, "", "");
        this.checkQueryParams(url, "a", "b");
    }

    public void testRender1() {
        Url url = new Url();
        url.getSegments().add("foo");
        url.getSegments().add("b=r");
        url.getSegments().add("b&z");
        url.getSegments().add("x?");
        url.setQueryParameter("a", (Object)"b");
        url.setQueryParameter("x?&4", (Object)"y=z");
        UrlTest.assertEquals((String)"foo/b=r/b&z/x%3F?a=b&x%3F%264=y%3Dz", (String)url.toString());
    }

    public void testRender2() {
        String s = "/absolute/url";
        Url url = Url.parse((String)s);
        UrlTest.assertEquals((String)url.toString(), (String)s);
    }

    public void testRender3() {
        String s = "//absolute/url";
        Url url = Url.parse((String)s);
        UrlTest.assertEquals((String)url.toString(), (String)s);
    }

    public void testRender4() {
        String s = "/";
        Url url = Url.parse((String)s);
        UrlTest.assertEquals((String)url.toString(), (String)s);
    }

    public void testAbsolute1() {
        Url url = Url.parse((String)"abc/efg");
        UrlTest.assertFalse((boolean)url.isAbsolute());
    }

    public void testAbsolute2() {
        Url url = Url.parse((String)"");
        UrlTest.assertFalse((boolean)url.isAbsolute());
    }

    public void testAbsolute3() {
        Url url = Url.parse((String)"/");
        UrlTest.assertTrue((boolean)url.isAbsolute());
    }

    public void testAbsolute4() {
        Url url = Url.parse((String)"/abc/efg");
        UrlTest.assertTrue((boolean)url.isAbsolute());
    }

    public void testConcat1() {
        Url url = Url.parse((String)"abc/efg");
        url.concatSegments(Arrays.asList("xx", "yy"));
        UrlTest.assertEquals((Object)Url.parse((String)"abc/xx/yy"), (Object)url);
    }

    public void testConcat2() {
        Url url = Url.parse((String)"abc/efg");
        url.concatSegments(Arrays.asList(".", "..", "xx", "yy"));
        UrlTest.assertEquals((Object)Url.parse((String)"xx/yy"), (Object)url);
    }

    public void testConcat3() {
        Url url = Url.parse((String)"abc/efg");
        url.concatSegments(Arrays.asList("..", "..", "xx", "yy"));
        UrlTest.assertEquals((Object)Url.parse((String)"xx/yy"), (Object)url);
    }

    public void testConcat4() {
        Url url = Url.parse((String)"abc/efg");
        url.concatSegments(Arrays.asList("..", "..", "..", "xx", "yy"));
        UrlTest.assertEquals((Object)Url.parse((String)"../xx/yy"), (Object)url);
    }

    public void testConcat5() {
        Url url = Url.parse((String)"abc/efg/");
        url.concatSegments(Arrays.asList("xx", "yy"));
        UrlTest.assertEquals((Object)Url.parse((String)"abc/efg/xx/yy"), (Object)url);
    }

    public void testConcat6() {
        Url url = Url.parse((String)"abc/efg/");
        url.concatSegments(Arrays.asList(".."));
        UrlTest.assertEquals((Object)Url.parse((String)"abc/"), (Object)url);
    }

    public void testConcat7() {
        Url url = Url.parse((String)"abc/efg/");
        url.concatSegments(Arrays.asList("..", ".."));
        UrlTest.assertEquals((Object)Url.parse((String)""), (Object)url);
    }

    public void testConcat8() {
        Url url = Url.parse((String)"fff/abc/efg/xxx");
        url.concatSegments(Arrays.asList(".."));
        UrlTest.assertEquals((Object)Url.parse((String)"fff/abc/"), (Object)url);
    }

    public void testConcat9() {
        Url url = Url.parse((String)"fff/abc/efg/xxx");
        url.concatSegments(Arrays.asList("..", ".."));
        UrlTest.assertEquals((Object)Url.parse((String)"fff/"), (Object)url);
    }

    public void testResolveRelative1() {
        Url relative = Url.parse((String)"./a/b?p1=v1");
        Url baseUrl = Url.parse((String)"c/d?p2=v2");
        baseUrl.resolveRelative(relative);
        UrlTest.assertEquals((String)"c/a/b?p1=v1", (String)baseUrl.toString());
    }

    public void testResolveRelative2() {
        Url relative = Url.parse((String)"a/b?p1=v1");
        Url baseUrl = Url.parse((String)"c/d?p2=v2");
        baseUrl.resolveRelative(relative);
        UrlTest.assertEquals((String)"c/a/b?p1=v1", (String)baseUrl.toString());
    }

    public void testResolveRelative3() {
        Url relative = Url.parse((String)"../a/b?p1=v1");
        Url baseUrl = Url.parse((String)"c/d");
        baseUrl.resolveRelative(relative);
        UrlTest.assertEquals((String)"a/b?p1=v1", (String)baseUrl.toString());
    }

    public void testResolveRelative_NoSegmentsInBase() {
        Url relative = Url.parse((String)"?a=b");
        Url baseUrl = Url.parse((String)"?foo=bar");
        baseUrl.resolveRelative(relative);
        UrlTest.assertEquals((String)"?a=b", (String)baseUrl.toString());
    }

    public void testResolveRelative_NoSegmentsInBase2() {
        Url relative = Url.parse((String)"bar/baz?a=b");
        Url baseUrl = Url.parse((String)"?foo=bar");
        baseUrl.resolveRelative(relative);
        UrlTest.assertEquals((String)"bar/baz?a=b", (String)baseUrl.toString());
    }

    public void testCharset1() {
        Url url = new Url();
        UrlTest.assertEquals((Object)Charset.forName("UTF-8"), (Object)url.getCharset());
    }

    public void testCharset2() {
        Charset expected = Charset.forName("ISO-8859-2");
        Url url = new Url(expected);
        UrlTest.assertEquals((Object)expected, (Object)url.getCharset());
    }

    public void testCharset3() throws Exception {
        Charset expected = Charset.forName("ISO-8859-1");
        Url url = new Url(expected);
        Url clonedUrl = this.cloneObject(url);
        UrlTest.assertEquals((Object)expected, (Object)clonedUrl.getCharset());
    }

    private Url cloneObject(Url url) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(url);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        return (Url)ois.readObject();
    }

    public void testParseRelativeUrl() {
        Url url = Url.parse((String)"foo");
        this.checkUrl(url, null, null, null, "foo");
        UrlTest.assertFalse((boolean)url.isAbsolute());
        url = Url.parse((String)"foo/bar/baz");
        this.checkUrl(url, null, null, null, "foo", "bar", "baz");
        UrlTest.assertFalse((boolean)url.isAbsolute());
        url = Url.parse((String)"?foobar");
        this.checkUrl(url, null, null, null, new String[0]);
        UrlTest.assertEquals((String)"", (String)url.getQueryParameter("foobar").getValue());
        UrlTest.assertFalse((boolean)url.isAbsolute());
        url = Url.parse((String)"foo?a=123");
        this.checkUrl(url, null, null, null, "foo");
        UrlTest.assertEquals((String)"123", (String)url.getQueryParameter("a").getValue());
        UrlTest.assertFalse((boolean)url.isAbsolute());
        url = Url.parse((String)"/foo");
        this.checkUrl(url, null, null, null, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
    }

    public void testParseAbsoluteUrl() {
        Url url = Url.parse((String)"ftp://myhost:8081");
        this.checkUrl(url, "ftp", "myhost", 8081, new String[0]);
        UrlTest.assertFalse((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"ftp://myhost:8081", (String)url.toAbsoluteString());
        url = Url.parse((String)"gopher://myhost:8081/foo");
        this.checkUrl(url, "gopher", "myhost", 8081, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"gopher://myhost:8081/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"http://myhost:80/foo");
        this.checkUrl(url, "http", "myhost", 80, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"http://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"http://myhost:81/foo");
        this.checkUrl(url, "http", "myhost", 81, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"http://myhost:81/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"http://myhost/foo");
        this.checkUrl(url, "http", "myhost", 80, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"http://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"https://myhost:443/foo");
        this.checkUrl(url, "https", "myhost", 443, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"https://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"HTTPS://myhost/foo:123");
        this.checkUrl(url, "https", "myhost", 443, "", "foo:123");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"https://myhost/foo:123", (String)url.toAbsoluteString());
        url = Url.parse((String)"ftp://myhost/foo");
        this.checkUrl(url, "ftp", "myhost", 21, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"ftp://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"ftp://myhost:21/foo");
        this.checkUrl(url, "ftp", "myhost", 21, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"ftp://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"ftp://user:pass@myhost:21/foo");
        this.checkUrl(url, "ftp", "user:pass@myhost", 21, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"ftp://user:pass@myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"FTp://myhost/foo");
        this.checkUrl(url, "ftp", "myhost", 21, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"ftp://myhost/foo", (String)url.toAbsoluteString());
        url = Url.parse((String)"unknown://myhost/foo");
        this.checkUrl(url, "unknown", "myhost", null, "", "foo");
        UrlTest.assertTrue((boolean)url.isAbsolute());
        UrlTest.assertEquals((String)"unknown://myhost/foo", (String)url.toAbsoluteString());
    }

    private void checkUrl(Url url, String protocol, String host, Integer port, String ... segments) {
        UrlTest.assertNotNull((Object)url);
        UrlTest.assertEquals((String)protocol, (String)url.getProtocol());
        UrlTest.assertEquals((String)host, (String)url.getHost());
        UrlTest.assertEquals((Object)port, (Object)url.getPort());
        UrlTest.assertEquals(Arrays.asList(segments), (Object)url.getSegments());
    }
}

