/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.wicket.request.HttpHeaderCollection;
import org.apache.wicket.util.time.Time;
import org.junit.Assert;
import org.junit.Test;

public class HttpHeaderCollectionTest {
    @Test
    public void testHeaderCollection() {
        HttpHeaderCollection headers = new HttpHeaderCollection();
        Assert.assertTrue((boolean)headers.isEmpty());
        headers.addHeader("X-Test", "foo");
        headers.addHeader("X-Test", "bar");
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])headers.getHeaderValues("X-Test"));
        headers.removeHeader("x-test");
        Assert.assertTrue((boolean)headers.isEmpty());
        headers.addHeader("   X-Image    ", "    jpeg     ");
        headers.addHeader("X-Image    ", "    gif     ");
        Assert.assertArrayEquals((Object[])new String[]{"jpeg", "gif"}, (Object[])headers.getHeaderValues("X-IMAGE"));
        Assert.assertEquals((long)1L, (long)headers.getCount());
        headers.addHeader("X-Test", "123");
        Assert.assertEquals((long)2L, (long)headers.getCount());
        headers.removeHeader(" x-tesT ");
        Assert.assertEquals((long)1L, (long)headers.getCount());
        headers.setHeader("foobaz", "");
        Assert.assertEquals((Object)"", (Object)headers.getHeader("foobaz"));
        headers.setHeader("foobaz", "     ");
        Assert.assertEquals((Object)"", (Object)headers.getHeader("foobaz"));
    }

    @Test
    public void getHeaderNames() {
        HttpHeaderCollection headers = new HttpHeaderCollection();
        headers.addHeader("key1", "a");
        headers.addHeader("Key1", "b");
        headers.addHeader("key2", "c");
        Set names = headers.getHeaderNames();
        Assert.assertTrue((boolean)names.contains("key1"));
        Assert.assertFalse((boolean)names.contains("Key1"));
        Assert.assertTrue((boolean)names.contains("key2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dateValues() {
        HttpHeaderCollection headers = new HttpHeaderCollection();
        Time time1 = Time.millis((long)1000000L);
        Time time2 = Time.millis((long)2000000L);
        headers.setDateHeader("date", time1);
        headers.addDateHeader("date", time2);
        headers.addHeader("date", "not-a-date");
        Assert.assertEquals((Object)time1, (Object)headers.getDateHeader("date"));
        Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:16:40 GMT", (Object)headers.getHeader("date"));
        Locale defaultLocale = Locale.getDefault();
        TimeZone defaultLocaleefaultTimezone = TimeZone.getDefault();
        try {
            String expected = "Thu, 01 Jan 1970 00:16:40 GMT";
            Locale.setDefault(Locale.CHINESE);
            TimeZone.setDefault(TimeZone.getTimeZone("CET"));
            Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:16:40 GMT", (Object)headers.getHeader("date"));
            Locale.setDefault(Locale.US);
            TimeZone.setDefault(TimeZone.getTimeZone("EST"));
            Assert.assertEquals((Object)"Thu, 01 Jan 1970 00:16:40 GMT", (Object)headers.getHeader("date"));
        }
        finally {
            Locale.setDefault(defaultLocale);
            TimeZone.setDefault(defaultLocaleefaultTimezone);
        }
        Assert.assertArrayEquals((Object[])new String[]{"Thu, 01 Jan 1970 00:16:40 GMT", "Thu, 01 Jan 1970 00:33:20 GMT", "not-a-date"}, (Object[])headers.getHeaderValues("date"));
        headers.setHeader("date", "foobar");
        try {
            Time date = headers.getDateHeader("date");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }
}

