/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlRequestParametersAdapter
implements IRequestParameters {
    private final Url url;

    public UrlRequestParametersAdapter(Url url) {
        Args.notNull((Object)url, (String)"url");
        this.url = url;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> result = new HashSet<String>();
        for (Url.QueryParameter parameter : this.url.getQueryParameters()) {
            result.add(parameter.getName());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public StringValue getParameterValue(String name) {
        return this.url.getQueryParameterValue(name);
    }

    @Override
    public List<StringValue> getParameterValues(String name) {
        ArrayList<StringValue> values = null;
        for (Url.QueryParameter parameter : this.url.getQueryParameters()) {
            if (!Objects.equal((Object)name, (Object)parameter.getName())) continue;
            if (values == null) {
                values = new ArrayList<StringValue>();
            }
            values.add(StringValue.valueOf((String)parameter.getValue()));
        }
        return values != null ? Collections.unmodifiableList(values) : null;
    }
}

