/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.mount;

import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.mount.IMountedRequestMapper;
import org.apache.wicket.request.mapper.mount.Mount;
import org.apache.wicket.request.mapper.mount.MountParameters;
import org.apache.wicket.request.mapper.mount.UnmountedMapperAdapter;
import org.apache.wicket.request.mapper.mount.UnmountedRequestHandlerAdapter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.StringValue;

public class MountMapper
extends AbstractMapper {
    private final String[] mountSegments;
    private final IMountedRequestMapper mapper;

    public MountMapper(String mountPath, IMountedRequestMapper mapper) {
        Args.notEmpty((String)mountPath, (String)"mountPath");
        Args.notNull((Object)mapper, (String)"mapper");
        this.mountSegments = this.getMountSegments(mountPath);
        this.mapper = mapper;
    }

    public MountMapper(String mountPath, IRequestMapper mapper) {
        Args.notEmpty((String)mountPath, (String)"mountPath");
        Args.notNull((Object)mapper, (String)"mapper");
        this.mountSegments = this.getMountSegments(mountPath);
        this.mapper = new UnmountedMapperAdapter(mapper);
    }

    public MountMapper(String mountPath, IRequestHandler handler) {
        Args.notEmpty((String)mountPath, (String)"mountPath");
        Args.notNull((Object)handler, (String)"handler");
        this.mountSegments = this.getMountSegments(mountPath);
        this.mapper = new UnmountedRequestHandlerAdapter(handler);
    }

    public int getCompatibilityScore(Request request) {
        if (this.urlStartsWith(request.getUrl(), this.mountSegments)) {
            return this.mountSegments.length + this.mapper.getCompatibilityScore(this.dismountRequest(request));
        }
        return 0;
    }

    private Request dismountRequest(Request request) {
        Url dismountedUrl = new Url(request.getUrl());
        dismountedUrl.removeLeadingSegments(this.mountSegments.length);
        return request.cloneWithUrl(dismountedUrl);
    }

    public final IRequestHandler mapRequest(Request request) {
        Url url = request.getUrl();
        if (url.getSegments().size() >= this.mountSegments.length && this.urlStartsWith(url, this.mountSegments)) {
            MountParameters params = new MountParameters();
            for (int i = 0; i < this.mountSegments.length; ++i) {
                String placeholder = MountMapper.getPlaceholder(this.mountSegments[i]);
                if (placeholder == null) continue;
                params.setValue(placeholder, StringValue.valueOf((String)url.getSegments().get(i)));
            }
            return this.mapper.mapRequest(this.dismountRequest(request), params);
        }
        return null;
    }

    public Url mapHandler(IRequestHandler handler) {
        Mount mount = this.mapper.mapHandler(handler);
        if (mount == null) {
            return null;
        }
        Checks.notNull((Object)mount.getUrl(), (String)"Mount's Url should not be null", (Object[])new Object[0]);
        Checks.notNull((Object)mount.getMountParameters(), (String)"Mount's parameters should not be null", (Object[])new Object[0]);
        for (int i = this.mountSegments.length; i > 0; --i) {
            String segment = this.mountSegments[i - 1];
            String placeholder = MountMapper.getPlaceholder(segment);
            String replacement = segment;
            if (placeholder != null) {
                replacement = mount.getMountParameters().getValue(placeholder).toString();
                Checks.notNull((Object)replacement, (String)"Cannot find a value for placeholder '%s'.", (Object[])new Object[]{placeholder});
            }
            mount.getUrl().getSegments().add(0, replacement);
        }
        return mount.getUrl();
    }
}

