/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRequest
extends Request {
    protected static final String PARAM_AJAX = "wicket-ajax";
    protected static final String HEADER_AJAX = "Wicket-Ajax";
    protected static final String PARAM_AJAX_BASE_URL = "wicket-ajax-baseurl";
    protected static final String HEADER_AJAX_BASE_URL = "Wicket-Ajax-BaseURL";

    public abstract List<Cookie> getCookies();

    public Cookie getCookie(String cookieName) {
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public abstract List<String> getHeaders(String var1);

    public abstract String getHeader(String var1);

    public abstract long getDateHeader(String var1);

    public final Date getIfModifiedSinceHeader() {
        long header = this.getDateHeader("If-Modified-Since");
        if (header >= 0L) {
            return new Date(header);
        }
        return null;
    }

    public boolean isAjax() {
        return Strings.isTrue((String)this.getHeader(HEADER_AJAX)) || Strings.isTrue((String)this.getRequestParameters().getParameterValue(PARAM_AJAX).toString());
    }

    @Override
    public WebRequest cloneWithUrl(final Url url) {
        return new WebRequest(){

            @Override
            public Url getUrl() {
                return url;
            }

            @Override
            public IRequestParameters getPostParameters() {
                return WebRequest.this.getPostParameters();
            }

            @Override
            public List<Cookie> getCookies() {
                return WebRequest.this.getCookies();
            }

            @Override
            public long getDateHeader(String name) {
                return WebRequest.this.getDateHeader(name);
            }

            @Override
            public Locale getLocale() {
                return WebRequest.this.getLocale();
            }

            @Override
            public String getHeader(String name) {
                return WebRequest.this.getHeader(name);
            }

            @Override
            public List<String> getHeaders(String name) {
                return WebRequest.this.getHeaders(name);
            }

            @Override
            public Charset getCharset() {
                return WebRequest.this.getCharset();
            }

            @Override
            public Url getClientUrl() {
                return WebRequest.this.getClientUrl();
            }
        };
    }
}

