/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedRequestParametersAdapter
implements IRequestParameters {
    private final IRequestParameters[] parameters;

    public CombinedRequestParametersAdapter(IRequestParameters ... parameters) {
        if (parameters == null) {
            throw new IllegalStateException("Argument 'parameters' may not be null");
        }
        this.parameters = parameters;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> result = new HashSet<String>();
        for (IRequestParameters p : this.parameters) {
            result.addAll(p.getParameterNames());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public StringValue getParameterValue(String name) {
        for (IRequestParameters p : this.parameters) {
            StringValue value = p.getParameterValue(name);
            if (value.isNull()) continue;
            return value;
        }
        return StringValue.valueOf((String)null);
    }

    @Override
    public List<StringValue> getParameterValues(String name) {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        for (IRequestParameters p : this.parameters) {
            List<StringValue> values = p.getParameterValues(name);
            if (values == null) continue;
            for (StringValue v : values) {
                if (result.contains(v)) continue;
                result.add(v);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(result);
    }
}

