/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http.handler;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.http.WebResponse;

public final class ErrorCodeResponseHandler
implements IRequestHandler {
    private final int errorCode;
    private final String message;

    public ErrorCodeResponseHandler(int errorCode) {
        this(errorCode, null);
    }

    public ErrorCodeResponseHandler(int errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public void respond(IRequestCycle requestCycle) {
        WebResponse webResponse = (WebResponse)requestCycle.getResponse();
        webResponse.sendError(this.errorCode, this.message);
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getMessage() {
        return this.message;
    }

    public void detach(IRequestCycle requestCycle) {
    }
}

