/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestHandlerStack {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerStack.class);
    private final LinkedList<IRequestHandler> requestHandlers = new LinkedList();
    private final List<IRequestHandler> inactiveRequestHandlers = new ArrayList<IRequestHandler>();
    private IRequestHandler scheduledAfterCurrent = null;
    private Response response;

    public RequestHandlerStack(Response response) {
        this.response = response;
    }

    protected abstract IRequestCycle getRequestCycle();

    public IRequestHandler getActiveRequestHandler() {
        return this.requestHandlers.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRequestHandler(IRequestHandler handler) {
        boolean first = this.requestHandlers.isEmpty();
        this.requestHandlers.add(handler);
        IRequestHandler replacementHandler = null;
        Response originalResponse = this.response;
        try {
            handler.respond(this.getRequestCycle());
        }
        catch (RuntimeException exception) {
            ReplaceHandlerException replacer = (ReplaceHandlerException)Exceptions.findCause((Throwable)exception, ReplaceHandlerException.class);
            if (replacer == null) {
                throw exception;
            }
            if (replacer.removeAll && !first) {
                throw exception;
            }
            replacementHandler = replacer.replacementRequestHandler;
        }
        finally {
            this.response = originalResponse;
            this.requestHandlers.poll();
            this.inactiveRequestHandlers.add(handler);
        }
        IRequestHandler scheduled = this.scheduledAfterCurrent;
        this.scheduledAfterCurrent = null;
        if (replacementHandler != null) {
            this.executeRequestHandler(replacementHandler);
        } else if (scheduled != null) {
            this.executeRequestHandler(scheduled);
        }
    }

    public void scheduleRequestHandlerAfterCurrent(IRequestHandler handler) {
        this.scheduledAfterCurrent = handler;
    }

    public IRequestHandler getRequestHandlerScheduledAfterCurrent() {
        return this.scheduledAfterCurrent;
    }

    public void replaceCurrentRequestHandler(IRequestHandler handler) {
        if (!this.requestHandlers.isEmpty()) {
            throw new ReplaceHandlerException(handler, false);
        }
        this.executeRequestHandler(handler);
    }

    public void replaceAllRequestHandlers(IRequestHandler handler) {
        if (!this.requestHandlers.isEmpty()) {
            throw new ReplaceHandlerException(handler, true);
        }
        this.executeRequestHandler(handler);
    }

    public Response getResponse() {
        return this.response;
    }

    public Response setResponse(Response response) {
        Response current = this.response;
        this.response = response;
        return current;
    }

    public void detach() {
        if (!this.requestHandlers.isEmpty()) {
            log.warn("Some of the request handlers are still active.");
            this.inactiveRequestHandlers.addAll(this.requestHandlers);
            this.requestHandlers.clear();
        }
        for (IRequestHandler handler : this.inactiveRequestHandlers) {
            try {
                handler.detach(this.getRequestCycle());
            }
            catch (Throwable exception) {
                log.error("Error detaching RequestHandler", exception);
            }
        }
    }

    public static class ReplaceHandlerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final boolean removeAll;
        private final IRequestHandler replacementRequestHandler;

        public ReplaceHandlerException(IRequestHandler replacementRequestHandler, boolean removeAll) {
            this.replacementRequestHandler = replacementRequestHandler;
            this.removeAll = removeAll;
        }

        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

