/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;

public class AbstractMapper {
    protected static String getPlaceholder(String s) {
        if (s == null || s.length() < 4 || !s.startsWith("${") || !s.endsWith("}")) {
            return null;
        }
        return s.substring(2, s.length() - 1);
    }

    protected boolean urlStartsWith(Url url, String ... segments) {
        if (url == null) {
            return false;
        }
        if (url.getSegments().size() < segments.length) {
            return false;
        }
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].equals(url.getSegments().get(i)) || AbstractMapper.getPlaceholder(segments[i]) != null) continue;
            return false;
        }
        return true;
    }

    protected PageParameters extractPageParameters(Request request, int segmentsToSkip, IPageParametersEncoder encoder) {
        Checks.argumentNotNull((Object)request, (String)"request");
        Checks.argumentNotNull((Object)encoder, (String)"encoder");
        Url urlCopy = new Url(request.getUrl());
        while (segmentsToSkip > 0 && !urlCopy.getSegments().isEmpty()) {
            urlCopy.getSegments().remove(0);
            --segmentsToSkip;
        }
        if (!urlCopy.getQueryParameters().isEmpty() && Strings.isEmpty((CharSequence)urlCopy.getQueryParameters().get(0).getValue())) {
            urlCopy.getQueryParameters().remove(0);
        }
        PageParameters decoded = encoder.decodePageParameters(request.requestWithUrl(urlCopy));
        return decoded;
    }

    protected Url encodePageParameters(Url url, PageParameters pageParameters, IPageParametersEncoder encoder) {
        Url parametersUrl;
        Checks.argumentNotNull((Object)url, (String)"url");
        Checks.argumentNotNull((Object)encoder, (String)"encoder");
        if (pageParameters == null) {
            pageParameters = new PageParameters();
        }
        if ((parametersUrl = encoder.encodePageParameters(pageParameters)) != null) {
            url = new Url(url);
            for (String s : parametersUrl.getSegments()) {
                url.getSegments().add(s);
            }
            for (Url.QueryParameter p : parametersUrl.getQueryParameters()) {
                url.getQueryParameters().add(p);
            }
        }
        return url;
    }

    protected String[] getMountSegments(String mountPath) {
        Url url;
        if (mountPath.startsWith("/")) {
            mountPath = mountPath.substring(1);
        }
        if ((url = Url.parse(mountPath)).getSegments().isEmpty()) {
            throw new IllegalArgumentException("Mount path must have at least one segment.");
        }
        String[] res = new String[url.getSegments().size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = url.getSegments().get(i);
        }
        return res;
    }
}

