/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.tree.content;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.content.StyledLinkLabel;
import org.apache.wicket.model.IModel;

public class Folder<T>
extends StyledLinkLabel<T> {
    private static final long serialVersionUID = 1L;
    public static final String OTHER_CSS_CLASS_KEY = CssUtils.key(Folder.class, (String)"other");
    public static final String CLOSED_CSS_CLASS_KEY = CssUtils.key(Folder.class, (String)"closed");
    public static final String OPEN_CSS_CLASS_KEY = CssUtils.key(Folder.class, (String)"open");
    public static final String SELECTED_CSS_CLASS_KEY = CssUtils.key(Folder.class, (String)"selected");
    private AbstractTree<T> tree;

    public Folder(String id, AbstractTree<T> tree, IModel<T> model) {
        super(id, model);
        this.tree = tree;
    }

    @Override
    protected boolean isClickable() {
        Object t = this.getModelObject();
        return this.tree.getProvider().hasChildren(t);
    }

    @Override
    protected void onClick(AjaxRequestTarget target) {
        Object t = this.getModelObject();
        if (this.tree.getState(t) == AbstractTree.State.EXPANDED) {
            this.tree.collapse(t);
        } else {
            this.tree.expand(t);
        }
    }

    @Override
    protected String getStyleClass() {
        Object t = this.getModelObject();
        String styleClass = this.tree.getProvider().hasChildren(t) ? (this.tree.getState(t) == AbstractTree.State.EXPANDED ? this.getOpenStyleClass() : this.getClosedStyleClass()) : this.getOtherStyleClass(t);
        if (this.isSelected()) {
            styleClass = styleClass + " " + this.getSelectedStyleClass();
        }
        return styleClass;
    }

    protected boolean isSelected() {
        return false;
    }

    protected String getOtherStyleClass(T t) {
        return this.getString(OTHER_CSS_CLASS_KEY);
    }

    protected String getClosedStyleClass() {
        return this.getString(CLOSED_CSS_CLASS_KEY);
    }

    protected String getOpenStyleClass() {
        return this.getString(OPEN_CSS_CLASS_KEY);
    }

    protected String getSelectedStyleClass() {
        return this.getString(SELECTED_CSS_CLASS_KEY);
    }
}

