/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.StringAutoCompleteRenderer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public abstract class AutoCompleteTextField<T>
extends TextField<T> {
    private static final long serialVersionUID = 1L;
    private AutoCompleteBehavior<T> behavior;
    private final IAutoCompleteRenderer<T> renderer;
    private final AutoCompleteSettings settings;

    public AutoCompleteTextField(String id, Class<T> type) {
        this(id, null, type, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, AutoCompleteSettings settings) {
        this(id, model, type, StringAutoCompleteRenderer.INSTANCE, settings);
    }

    public AutoCompleteTextField(String id, IModel<T> model, AutoCompleteSettings settings) {
        this(id, model, null, settings);
    }

    public AutoCompleteTextField(String id, IModel<T> model) {
        this(id, model, null, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, AutoCompleteSettings settings) {
        this(id, null, settings);
    }

    public AutoCompleteTextField(String id) {
        this(id, null, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IAutoCompleteRenderer<T> renderer) {
        this(id, (IModel)null, renderer);
    }

    public AutoCompleteTextField(String id, Class<T> type, IAutoCompleteRenderer<T> renderer) {
        this(id, null, type, renderer, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IModel<T> model, IAutoCompleteRenderer<T> renderer) {
        this(id, model, null, renderer, new AutoCompleteSettings());
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type, IAutoCompleteRenderer<T> renderer, AutoCompleteSettings settings) {
        super(id, model, type);
        this.renderer = renderer;
        this.settings = settings;
    }

    protected AutoCompleteBehavior<T> newAutoCompleteBehavior(IAutoCompleteRenderer<T> renderer, AutoCompleteSettings settings) {
        return new AutoCompleteBehavior<T>(renderer, settings){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator<T> getChoices(String input) {
                return AutoCompleteTextField.this.getChoices(input);
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AutoCompleteTextField.this.updateAjaxAttributes(attributes);
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void onInitialize() {
        super.onInitialize();
        this.initializeAutoCompleteBehavior();
    }

    private void initializeAutoCompleteBehavior() {
        if (this.behavior == null) {
            Behavior[] behaviorArray = new Behavior[1];
            this.behavior = this.newAutoCompleteBehavior(this.renderer, this.settings);
            behaviorArray[0] = this.behavior;
            super.add(behaviorArray);
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("autocomplete", (CharSequence)"off");
    }

    protected abstract Iterator<T> getChoices(String var1);

    public final IAutoCompleteRenderer<T> getChoiceRenderer() {
        return this.renderer;
    }
}

