/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.base.markdown;

import org.apache.wicket.examples.base.markdown.Markdown;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class MarkdownLabel
extends Label {
    private static final long serialVersionUID = 1L;

    public MarkdownLabel(String id) {
        super(id);
    }

    public MarkdownLabel(String id, IModel<?> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setEscapeModelStrings(false);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String markdown = this.getModelObjectAsUnescapedString();
        String html = Markdown.markdownToHtml(markdown);
        this.replaceComponentTagBody(markupStream, openTag, html);
    }

    private String getModelObjectAsUnescapedString() {
        Object modelObject = this.getDefaultModelObject();
        if (modelObject != null) {
            Class<?> objectClass = modelObject.getClass();
            IConverter converter = this.getConverter(objectClass);
            String modelString = converter.convertToString(modelObject, this.getLocale());
            return modelString;
        }
        return null;
    }
}

