/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.basic.guestbook;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.examples.basic.guestbook.Comment;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;

public class GuestbookPage
extends WebPage {
    private static final CopyOnWriteArrayList<Comment> comments = new CopyOnWriteArrayList();
    private final TextArea<String> commentField;
    private final TextField<String> authorField;

    public GuestbookPage() {
        this.add(new Component[]{new ListView<Comment>("comments", this.getCommentsModel()){

            protected void populateItem(ListItem<Comment> item) {
                item.add(new Component[]{new Label("author", ((Comment)item.getModelObject()).getAuthor())});
                item.add(new Component[]{new Label("comment", ((Comment)item.getModelObject()).getText())});
            }
        }});
        Form<Void> form = new Form<Void>("form"){

            protected void onSubmit() {
                super.onSubmit();
                String author = (String)GuestbookPage.this.authorField.getModelObject();
                String text = (String)GuestbookPage.this.commentField.getModelObject();
                GuestbookPage.this.commentField.setModelObject((Object)"");
                comments.add(0, new Comment(author, text));
            }
        };
        this.add(new Component[]{form});
        Component[] componentArray = new Component[1];
        this.authorField = new TextField("author", (IModel)Model.of((Serializable)((Object)"")));
        componentArray[0] = this.authorField;
        form.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.commentField = new TextArea("comment", (IModel)Model.of((Serializable)((Object)"")));
        componentArray2[0] = this.commentField;
        form.add(componentArray2);
    }

    public IModel<List<Comment>> getCommentsModel() {
        LoadableDetachableModel<List<Comment>> commentsModel = new LoadableDetachableModel<List<Comment>>(){

            protected List<Comment> load() {
                return comments;
            }
        };
        return commentsModel;
    }

    protected void onConfigure() {
        super.onConfigure();
        for (Comment comment : comments) {
            Time createdAt = Time.valueOf((Date)comment.getCreatedAt());
            if (!(Duration.elapsed((Time)createdAt).seconds() > 10.0)) continue;
            comments.remove(comment);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
    }
}

