/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.examples.base.markup;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.apache.wicket.markup.ComponentTag;

public class ClassValue
implements CharSequence {
    private static final Splitter splitter = Splitter.onPattern((String)"\\s+");
    private final LinkedHashSet<String> values;

    public static ClassValue of(ComponentTag tag) {
        return ClassValue.of(tag.getAttribute("class"));
    }

    public static ClassValue of(CharSequence value) {
        return new ClassValue(splitter.split(value == null ? "" : value));
    }

    private ClassValue(Iterable<String> values) {
        this.values = Sets.newLinkedHashSet(values);
        this.values.remove("");
    }

    private String join() {
        return Joiner.on((char)' ').join(this.values);
    }

    public ClassValue without(String clz) {
        this.values.remove(clz);
        return this;
    }

    public ClassValue with(String clz) {
        this.values.add(clz);
        return this;
    }

    @Override
    public String toString() {
        return Joiner.on((char)' ').join(this.values);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }
}

