/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.ZeroPaddingIntegerConverter;
import org.apache.wicket.util.lang.EnumeratedType;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;

public class DateTimeField
extends FormComponentPanel {
    private static final IConverter MINUTES_CONVERTER = new ZeroPaddingIntegerConverter(2);
    private static final long serialVersionUID = 1L;
    private AM_PM amOrPm = AM_PM.AM;
    private DropDownChoice amOrPmChoice;
    private MutableDateTime date;
    private DateTextField dateField;
    private Integer hours;
    private TextField hoursField;
    private Integer minutes;
    private TextField minutesField;

    public DateTimeField(String id) {
        this(id, null);
    }

    public DateTimeField(String id, IModel model) {
        super(id, model);
        this.setType(Date.class);
        PropertyModel dateFieldModel = new PropertyModel((Object)this, "date");
        this.dateField = this.newDateTextField("date", dateFieldModel);
        this.add((Component)this.dateField);
        this.dateField.add((IBehavior)new DatePicker(){
            private static final long serialVersionUID = 1L;

            protected void configure(Map widgetProperties) {
                super.configure(widgetProperties);
                DateTimeField.this.configure(widgetProperties);
            }
        });
        this.hoursField = new TextField("hours", (IModel)new PropertyModel((Object)this, "hours"), Integer.class);
        this.add((Component)this.hoursField);
        this.hoursField.add((IValidator)new HoursValidator());
        this.hoursField.setLabel((IModel)new Model((Serializable)((Object)"hours")));
        this.minutesField = new TextField("minutes", (IModel)new PropertyModel((Object)this, "minutes"), Integer.class){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class type) {
                return MINUTES_CONVERTER;
            }
        };
        this.add((Component)this.minutesField);
        this.minutesField.add((IValidator)NumberValidator.range((long)0L, (long)59L));
        this.minutesField.setLabel((IModel)new Model((Serializable)((Object)"minutes")));
        this.amOrPmChoice = new DropDownChoice("amOrPmChoice", (IModel)new PropertyModel((Object)this, "amOrPm"), Arrays.asList(AM_PM.values()));
        this.add((Component)this.amOrPmChoice);
    }

    public AM_PM getAmOrPm() {
        return this.amOrPm;
    }

    public Date getDate() {
        return this.date != null ? this.date.toDate() : null;
    }

    public Integer getHours() {
        return this.hours;
    }

    protected void configure(Map widgetProperties) {
    }

    public String getInput() {
        return this.dateField.getInput() + ", " + this.hoursField.getInput() + ":" + this.minutesField.getInput();
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public void setAmOrPm(AM_PM amOrPm) {
        this.amOrPm = amOrPm;
    }

    public void setDate(Date date) {
        this.date = date != null ? new MutableDateTime((Object)date) : null;
        this.setModelObject(date);
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    protected TimeZone getClientTimeZone() {
        ClientInfo info = Session.get().getClientInfo();
        if (info instanceof WebClientInfo) {
            return ((WebClientInfo)info).getProperties().getTimeZone();
        }
        return null;
    }

    protected void convertInput() {
        Object dateFieldInput = this.dateField.getConvertedInput();
        if (dateFieldInput != null) {
            MutableDateTime date = new MutableDateTime(dateFieldInput);
            Integer hours = (Integer)this.hoursField.getConvertedInput();
            Integer minutes = (Integer)this.minutesField.getConvertedInput();
            AM_PM amOrPm = (AM_PM)((Object)this.amOrPmChoice.getConvertedInput());
            try {
                TimeZone zone;
                boolean use12HourFormat = this.use12HourFormat();
                if (hours != null) {
                    date.set(DateTimeFieldType.hourOfDay(), hours % this.getMaximumHours(use12HourFormat));
                    date.setMinuteOfHour(minutes != null ? minutes : 0);
                }
                if (use12HourFormat) {
                    date.set(DateTimeFieldType.halfdayOfDay(), amOrPm == AM_PM.PM ? 1 : 0);
                }
                if ((zone = this.getClientTimeZone()) != null) {
                    date.setMillis(DateTimeZone.getDefault().getMillisKeepLocal(DateTimeZone.forTimeZone((TimeZone)zone), date.getMillis()));
                }
                this.setConvertedInput(date.toDate());
            }
            catch (RuntimeException e) {
                this.error((Serializable)((Object)e.getMessage()));
                this.invalid();
            }
        } else {
            this.setConvertedInput(null);
        }
    }

    protected final DateTextField newDateTextField(PropertyModel dateFieldModel) {
        throw new UnsupportedOperationException();
    }

    protected DateTextField newDateTextField(String id, PropertyModel dateFieldModel) {
        return new DateTextField(id, (IModel)dateFieldModel, new StyleDateConverter(false));
    }

    protected void onBeforeRender() {
        this.dateField.setRequired(this.isRequired());
        this.hoursField.setRequired(this.isRequired());
        this.minutesField.setRequired(this.isRequired());
        this.dateField.setEnabled(this.isEnabled() && this.isEnableAllowed());
        this.hoursField.setEnabled(this.isEnabled() && this.isEnableAllowed());
        this.minutesField.setEnabled(this.isEnabled() && this.isEnableAllowed());
        this.amOrPmChoice.setEnabled(this.isEnabled() && this.isEnableAllowed());
        boolean use12HourFormat = this.use12HourFormat();
        this.amOrPmChoice.setVisible(use12HourFormat);
        Date d = (Date)this.getModelObject();
        this.date = d != null ? new MutableDateTime((Object)d) : null;
        if (this.date != null) {
            int hourOfHalfDay;
            TimeZone zone = this.getClientTimeZone();
            if (zone != null) {
                this.date.setZone(DateTimeZone.forTimeZone((TimeZone)zone));
            }
            this.hours = use12HourFormat ? new Integer((hourOfHalfDay = this.date.get(DateTimeFieldType.hourOfHalfday())) == 0 ? 12 : hourOfHalfDay) : new Integer(this.date.get(DateTimeFieldType.hourOfDay()));
            this.amOrPm = this.date.get(DateTimeFieldType.halfdayOfDay()) == 0 ? AM_PM.AM : AM_PM.PM;
            this.minutes = new Integer(this.date.getMinuteOfHour());
        }
        super.onBeforeRender();
    }

    protected boolean use12HourFormat() {
        String pattern = DateTimeFormat.patternForStyle((String)"-S", (Locale)this.getLocale());
        return pattern.indexOf(97) != -1 || pattern.indexOf(104) != -1 || pattern.indexOf(75) != -1;
    }

    private int getMaximumHours() {
        return this.getMaximumHours(this.use12HourFormat());
    }

    private int getMaximumHours(boolean use12HourFormat) {
        return use12HourFormat ? 12 : 24;
    }

    private class HoursValidator
    extends NumberValidator {
        private static final long serialVersionUID = 1L;

        private HoursValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            Number value = (Number)validatable.getValue();
            if (value.longValue() < 0L || value.longValue() > (long)DateTimeField.this.getMaximumHours()) {
                this.error(validatable);
            }
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Long(0L));
            map.put("maximum", new Long(DateTimeField.this.getMaximumHours()));
            return map;
        }

        protected String resourceKey() {
            return "NumberValidator.range";
        }
    }

    private static class AM_PM
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;
        static final AM_PM AM = new AM_PM("AM");
        static final AM_PM PM = new AM_PM("PM");

        public static AM_PM[] values() {
            return new AM_PM[]{AM, PM};
        }

        private AM_PM(String name) {
            super(name);
        }
    }
}

