/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.joda.time.MutableDateTime;

public class DateField
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private MutableDateTime date;
    private final DateTextField dateField;

    public DateField(String id) {
        this(id, null);
    }

    public DateField(String id, IModel model) {
        super(id, model);
        this.setType(Date.class);
        PropertyModel dateFieldModel = new PropertyModel((Object)this, "date");
        this.dateField = this.newDateTextField("date", dateFieldModel);
        this.add((Component)this.dateField);
        this.dateField.add((IBehavior)new DatePicker());
    }

    public Date getDate() {
        return this.date != null ? this.date.toDate() : null;
    }

    public String getInput() {
        return this.dateField.getInput();
    }

    public void setDate(Date date) {
        this.date = date != null ? new MutableDateTime((Object)date) : null;
        this.setModelObject(date);
    }

    protected void convertInput() {
        this.setConvertedInput(this.dateField.getConvertedInput());
    }

    protected final DateTextField newDateTextField(PropertyModel dateFieldModel) {
        throw new UnsupportedOperationException();
    }

    protected DateTextField newDateTextField(String id, PropertyModel dateFieldModel) {
        return DateTextField.forShortStyle(id, (IModel)dateFieldModel);
    }

    protected void onBeforeRender() {
        this.dateField.setRequired(this.isRequired());
        this.dateField.setEnabled(this.isEnabled() && this.isEnableAllowed());
        Date d = (Date)this.getModelObject();
        this.date = d != null ? new MutableDateTime((Object)d) : null;
        super.onBeforeRender();
    }
}

