/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.commons.fileupload2.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class LimitedInputStream
extends FilterInputStream {
    private final long sizeMax;
    private long count;

    public LimitedInputStream(InputStream inputStream, long sizeMax) {
        super(inputStream);
        this.sizeMax = sizeMax;
    }

    private void checkLimit() throws IOException {
        if (this.count > this.sizeMax) {
            this.raiseError(this.sizeMax, this.count);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    protected abstract void raiseError(long var1, long var3) throws IOException;

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }
}

