/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authorization.strategies.role.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.IClusterable;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;

public final class ActionPermissions
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Map<Action, Roles> rolesForAction = new HashMap<Action, Roles>();

    public final void authorize(Action action, Roles rolesToAdd) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        if (rolesToAdd == null) {
            throw new IllegalArgumentException("Argument rolesToAdd cannot be null");
        }
        Roles roles = this.rolesForAction.get(action);
        if (roles == null) {
            roles = new Roles();
            this.rolesForAction.put(action, roles);
        }
        roles.addAll(rolesToAdd);
    }

    public final void authorizeAll(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        this.rolesForAction.remove(action);
    }

    public final Roles rolesFor(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        return this.rolesForAction.get(action);
    }

    public final void unauthorize(Action action, Roles rolesToRemove) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action cannot be null");
        }
        if (rolesToRemove == null) {
            throw new IllegalArgumentException("Argument rolesToRemove cannot be null");
        }
        Roles roles = this.rolesForAction.get(action);
        if (roles != null) {
            roles.removeAll(rolesToRemove);
        } else {
            roles = new Roles();
            this.rolesForAction.put(action, roles);
        }
        if (roles.size() == 0) {
            roles.add("wicket:NO_ROLE");
        }
    }
}

