/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies.role.metadata;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.authorization.strategies.role.Roles;
import org.apache.wicket.request.component.IRequestableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiationPermissions
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Map<Class<? extends Component>, Roles> rolesForComponentClass = new HashMap<Class<? extends Component>, Roles>();

    public final <T extends Component> void authorize(Class<T> componentClass, Roles rolesToAdd) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        if (rolesToAdd == null) {
            throw new IllegalArgumentException("Argument rolesToadd cannot be null");
        }
        Roles roles = this.rolesForComponentClass.get(componentClass);
        if (roles == null) {
            roles = new Roles();
            this.rolesForComponentClass.put(componentClass, roles);
        }
        roles.addAll(rolesToAdd);
    }

    public final <T extends Component> void authorizeAll(Class<T> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        this.rolesForComponentClass.remove(componentClass);
    }

    public <T extends IRequestableComponent> Roles authorizedRoles(Class<T> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        return this.rolesForComponentClass.get(componentClass);
    }

    public final <T extends Component> void unauthorize(Class<T> componentClass, Roles rolesToRemove) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        if (rolesToRemove == null) {
            throw new IllegalArgumentException("Argument rolesToRemove cannot be null");
        }
        Roles roles = this.rolesForComponentClass.get(componentClass);
        if (roles != null) {
            roles.removeAll(rolesToRemove);
        } else {
            roles = new Roles();
            this.rolesForComponentClass.put(componentClass, roles);
        }
        if (roles.size() == 0) {
            roles.add("wicket:NO_ROLE");
        }
    }

    protected final Map<Class<? extends Component>, Roles> getRolesForComponentClass() {
        return this.rolesForComponentClass;
    }
}

