/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authentication.panel;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authentication.AuthenticatedWebSession;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignInPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SignInPanel.class);
    private boolean includeRememberMe = true;
    private boolean rememberMe = true;
    private String password;
    private String username;

    public SignInPanel(String id) {
        this(id, true);
    }

    public SignInPanel(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new SignInForm("signInForm")});
    }

    protected void onBeforeRender() {
        String[] data;
        if (!this.isSignedIn() && (data = this.getApplication().getSecuritySettings().getAuthenticationStrategy().load()) != null && data.length > 1 && this.signIn(data[0], data[1])) {
            this.username = data[0];
            this.password = data[1];
            if (!this.continueToOriginalDestination()) {
                throw new RestartResponseException(this.getApplication().getSessionSettings().getPageFactory().newPage(this.getApplication().getHomePage()));
            }
        }
        super.onBeforeRender();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    private boolean signIn(String username, String password) {
        return AuthenticatedWebSession.get().signIn(username, password);
    }

    private boolean isSignedIn() {
        return AuthenticatedWebSession.get().isSignedIn();
    }

    protected void onSignInFailed() {
        this.error((Serializable)((Object)this.getLocalizer().getString("signInFailed", (Component)this, "Sign in failed")));
    }

    protected void onSignInSucceeded() {
        if (!this.continueToOriginalDestination()) {
            this.setResponsePage(this.getApplication().getHomePage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SignInForm
    extends StatelessForm<SignInPanel> {
        private static final long serialVersionUID = 1L;

        public SignInForm(String id) {
            super(id);
            this.setModel((IModel)new CompoundPropertyModel((Object)SignInPanel.this));
            this.add(new Component[]{new TextField("username")});
            this.add(new Component[]{new PasswordTextField("password")});
            WebMarkupContainer rememberMeRow = new WebMarkupContainer("rememberMeRow");
            this.add(new Component[]{rememberMeRow});
            rememberMeRow.add(new Component[]{new CheckBox("rememberMe")});
            rememberMeRow.setVisible(SignInPanel.this.includeRememberMe);
        }

        public final void onSubmit() {
            IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
            if (SignInPanel.this.signIn(SignInPanel.this.getUsername(), SignInPanel.this.getPassword())) {
                SignInPanel.this.onSignInSucceeded();
                if (SignInPanel.this.rememberMe) {
                    strategy.save(SignInPanel.this.username, SignInPanel.this.password);
                } else {
                    strategy.remove();
                }
            } else {
                SignInPanel.this.onSignInFailed();
                strategy.remove();
            }
        }
    }
}

