/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authentication;

import java.lang.ref.WeakReference;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.Response;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authentication.AuthenticatedWebSession;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.role.Roles;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatedWebApplication
extends WebApplication
implements IRoleCheckingStrategy,
IUnauthorizedComponentInstantiationListener {
    private final WeakReference<Class<? extends AuthenticatedWebSession>> webSessionClassRef = new WeakReference<Class<? extends AuthenticatedWebSession>>(this.getWebSessionClass());

    protected void init() {
        super.init();
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy(this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
    }

    @Override
    public final boolean hasAnyRole(Roles roles) {
        Roles sessionRoles = AuthenticatedWebSession.get().getRoles();
        return sessionRoles != null && sessionRoles.hasAnyRole(roles);
    }

    public final void onUnauthorizedInstantiation(Component component) {
        if (component instanceof Page) {
            if (!AuthenticatedWebSession.get().isSignedIn()) {
                throw new RestartResponseAtInterceptPageException(this.getSignInPageClass());
            }
        } else {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        this.onUnauthorizedPage((Page)component);
    }

    public Session newSession(Request request, Response response) {
        try {
            return (Session)((Class)this.webSessionClassRef.get()).getDeclaredConstructor(AuthenticatedWebApplication.class, Request.class).newInstance(this, request);
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Unable to instantiate web session " + this.webSessionClassRef.get(), (Throwable)e);
        }
    }

    protected abstract Class<? extends AuthenticatedWebSession> getWebSessionClass();

    protected abstract Class<? extends WebPage> getSignInPageClass();

    protected void onUnauthorizedPage(Page page) {
        throw new UnauthorizedInstantiationException(page.getClass());
    }
}

