/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.kerberos.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.whirr.service.ClusterActionHandler;
import org.apache.whirr.service.kerberos.KerberosClientHandler;
import org.apache.whirr.service.kerberos.KerberosServerHandler;
import org.jclouds.scriptbuilder.functionloader.osgi.BundleFunctionLoader;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleFunctionLoader functionLoader;
    private final ClusterActionHandler clientActionHandler = new KerberosClientHandler();
    private ServiceRegistration clientRegistration;
    private final ClusterActionHandler serverClusterActionHandler = new KerberosServerHandler();
    private ServiceRegistration serverRegistration;

    public void start(BundleContext context) throws Exception {
        this.functionLoader = new BundleFunctionLoader(context);
        this.functionLoader.start();
        Properties clientProps = new Properties();
        clientProps.put("name", "kerberosclient");
        this.clientRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.clientActionHandler, (Dictionary)clientProps);
        Properties serverProps = new Properties();
        serverProps.put("name", "kerberosserver");
        this.serverRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.serverClusterActionHandler, (Dictionary)serverProps);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.clientRegistration != null) {
            this.clientRegistration.unregister();
        }
        if (this.serverRegistration != null) {
            this.serverRegistration.unregister();
        }
        if (this.functionLoader != null) {
            this.functionLoader.stop();
        }
    }
}

