/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.kerberos;

import java.io.IOException;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.kerberos.KerberosBaseHandler;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class KerberosServerHandler
extends KerberosBaseHandler {
    public static final String ROLE = "kerberosserver";
    private static final String PROPERTY_PORTS = "kerberosserver.ports";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        super.beforeBootstrap(event);
        KerberosServerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_kerberos_server", (String[])new String[0]));
    }

    @Override
    protected void beforeConfigure(ClusterActionEvent event) throws IOException {
        super.beforeConfigure(event);
        KerberosServerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_kerberos_server", (String[])new String[0]));
        for (Object port : this.getConfiguration(event.getClusterSpec()).getList(PROPERTY_PORTS)) {
            if (port == null || "".equals(port)) continue;
            event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(RolePredicates.role((String)ROLE)).port(Integer.parseInt(port.toString())));
        }
    }
}

