/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hama;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopProxy;
import org.apache.whirr.service.hama.HamaCluster;
import org.apache.whirr.service.hama.HamaClusterActionHandler;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HamaMasterClusterActionHandler
extends HamaClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HamaMasterClusterActionHandler.class);
    public static final String ROLE = "hama-master";
    public static final int MASTER_PORT = 40000;
    public static final int MASTER_WEB_UI_PORT = 40013;

    public String getRole() {
        return ROLE;
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Authorizing firewall");
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(instance).ports(new int[]{40013}), FirewallManager.Rule.create().destination(instance).ports(new int[]{40000})});
        String hamaConfigureFunction = this.getConfiguration(clusterSpec).getString("whirr.hama.configure-function", "configure_hama");
        String master = masterPublicAddress.getHostName();
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        String tarurl = HamaMasterClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)this.getConfiguration(clusterSpec).getString("whirr.hama.tarball.url"));
        HamaMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)hamaConfigureFunction, (String[])new String[]{ROLE, "-m", master, "-q", quorum, "-u", tarurl}));
        String hamaStartFunction = this.getConfiguration(clusterSpec).getString("whirr.hama.start-function", "start_hama");
        HamaMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)hamaStartFunction, (String[])new String[]{ROLE, "-u", tarurl}));
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {}", (Object)clusterSpec.getClusterName());
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        LOG.info("BSPMaster web UI available at http://{}:{}", (Object)masterPublicAddress.getHostName(), (Object)40013);
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        Properties config = this.createClientSideProperties(masterPublicAddress, quorum);
        this.createClientSideHadoopSiteFile(clusterSpec, config);
        this.createProxyScript(clusterSpec, cluster);
        event.setCluster(new Cluster(cluster.getInstances(), config));
    }

    private Properties createClientSideProperties(InetAddress master, String quorum) throws IOException {
        Properties config = new Properties();
        config.setProperty("hama.zookeeper.quorum", quorum);
        config.setProperty("hama.zookeeper.property.clientPort", "2181");
        config.setProperty("bsp.master.address", master.getHostName() + ":" + 40000);
        config.setProperty("hadoop.socks.server", "localhost:6666");
        config.setProperty("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.SocksSocketFactory");
        config.setProperty("hadoop.rpc.socket.factory.class.JobSubmissionProtocol", "org.apache.hadoop.net.StandardSocketFactory");
        return config;
    }

    private void createClientSideHadoopSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = this.getConfigDir(clusterSpec);
        File hamaSiteFile = new File(configDir, "hama-site.xml");
        try {
            Files.write((CharSequence)this.generateHamaConfigurationFile(config), (File)hamaSiteFile, (Charset)Charsets.UTF_8);
            LOG.info("Wrote Hama site file {}", (Object)hamaSiteFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing Hama site file {}", (Object)hamaSiteFile, (Object)e);
        }
    }

    private File getConfigDir(ClusterSpec clusterSpec) {
        File configDir = new File(new File(System.getProperty("user.home")), ".whirr");
        configDir = new File(configDir, clusterSpec.getClusterName());
        configDir.mkdirs();
        return configDir;
    }

    private CharSequence generateHamaConfigurationFile(Properties config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n");
        sb.append("<configuration>\n");
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            sb.append("  <property>\n");
            sb.append("    <name>").append(entry.getKey()).append("</name>\n");
            sb.append("    <value>").append(entry.getValue()).append("</value>\n");
            sb.append("  </property>\n");
        }
        sb.append("</configuration>\n");
        return sb;
    }

    private void createProxyScript(ClusterSpec clusterSpec, Cluster cluster) {
        File configDir = this.getConfigDir(clusterSpec);
        File hamaProxyFile = new File(configDir, "hama-proxy.sh");
        try {
            HadoopProxy proxy = new HadoopProxy(clusterSpec, cluster);
            InetAddress master = HamaCluster.getMasterPublicAddress(cluster);
            String script = String.format("echo 'Running proxy to Hama cluster at %s. Use Ctrl-c to quit.'\n", master.getHostName()) + Joiner.on((String)" ").join((Object[])proxy.getProxyCommand());
            Files.write((CharSequence)script, (File)hamaProxyFile, (Charset)Charsets.UTF_8);
            LOG.info("Wrote Hama proxy script {}", (Object)hamaProxyFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing Hama proxy script {}", (Object)hamaProxyFile, (Object)e);
        }
    }
}

