/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hama;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hama.HamaClusterActionHandler;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class HamaGroomServerClusterActionHandler
extends HamaClusterActionHandler {
    public static final String ROLE = "hama-groomserver";
    public static final int GROOMSERVER_PORT = 50000;

    public String getRole() {
        return ROLE;
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)"hama-master"));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(instance).ports(new int[]{61000, 50000})});
        String hamaConfigureFunction = this.getConfiguration(clusterSpec).getString("whirr.hama.configure-function", "configure_hama");
        String master = masterPublicAddress.getHostName();
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        String tarurl = HamaGroomServerClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)this.getConfiguration(clusterSpec).getString("whirr.hama.tarball.url"));
        HamaGroomServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)hamaConfigureFunction, (String[])new String[]{ROLE, "-m", master, "-q", quorum, "-u", tarurl}));
        String hamaStartFunction = this.getConfiguration(clusterSpec).getString("whirr.hama.start-function", "start_hama");
        HamaGroomServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)hamaStartFunction, (String[])new String[]{ROLE, "-u", tarurl}));
    }
}

