/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.tools.config.DefaultKey;

@DefaultKey(value="esc")
public class EscapeTool {
    public String java(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeJava((String)String.valueOf(string));
    }

    public String propertyKey(Object string) {
        if (string == null) {
            return null;
        }
        return this.dumpString(String.valueOf(string), true);
    }

    public String propertyValue(Object string) {
        if (string == null) {
            return null;
        }
        return this.dumpString(String.valueOf(string), false);
    }

    protected String dumpString(String string, boolean key) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || key && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public String javascript(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeJavaScript((String)String.valueOf(string));
    }

    public String html(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeHtml((String)String.valueOf(string));
    }

    public String url(Object string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(String.valueOf(string), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public String xml(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml((String)String.valueOf(string));
    }

    public String sql(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeSql((String)String.valueOf(string));
    }

    public String getDollar() {
        return "$";
    }

    public String getD() {
        return this.getDollar();
    }

    public String getHash() {
        return "#";
    }

    public String getH() {
        return this.getHash();
    }

    public String getBackslash() {
        return "\\";
    }

    public String getB() {
        return this.getBackslash();
    }

    public String getQuote() {
        return "\"";
    }

    public String getQ() {
        return this.getQuote();
    }

    public String getSingleQuote() {
        return "'";
    }

    public String getS() {
        return this.getSingleQuote();
    }

    public String getExclamation() {
        return "!";
    }

    public String getE() {
        return this.getExclamation();
    }
}

