/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.config;

import java.util.List;
import org.apache.velocity.tools.config.CompoundConfiguration;
import org.apache.velocity.tools.config.Configuration;
import org.apache.velocity.tools.config.ConfigurationException;
import org.apache.velocity.tools.config.InvalidScopeException;
import org.apache.velocity.tools.config.ToolConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolboxConfiguration
extends CompoundConfiguration<ToolConfiguration> {
    private String scope = "request";

    @Override
    protected ToolConfiguration findMatchingChild(ToolConfiguration newTool) {
        String newKey = newTool.getKey();
        if (newKey == null) {
            return null;
        }
        for (ToolConfiguration tool : this.getTools()) {
            if (!newKey.equals(tool.getKey())) continue;
            return tool;
        }
        return null;
    }

    public void addConfiguration(ToolboxConfiguration config) {
        super.addConfiguration(config);
        for (ToolConfiguration newTool : config.getTools()) {
            ToolConfiguration child = this.findMatchingChild(newTool);
            if (child == null) {
                this.addTool(newTool);
                continue;
            }
            child.addConfiguration(newTool);
            String newClass = newTool.getClassname();
            if (newClass == null) continue;
            child.setClassname(newClass);
        }
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void addTool(ToolConfiguration tool) {
        this.addChild(tool);
    }

    public void removeTool(ToolConfiguration tool) {
        this.removeChild(tool);
    }

    public List<ToolConfiguration> getTools() {
        return this.getChildren();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getScope() == null) {
            throw new ConfigurationException((Configuration)this, "Toolbox scope cannot be null");
        }
        for (ToolConfiguration tool : this.getTools()) {
            for (String invalidScope : tool.getInvalidScopes()) {
                if (!this.getScope().equals(invalidScope)) continue;
                throw new InvalidScopeException(this, tool);
            }
            String[] validScopes = tool.getValidScopes();
            if (validScopes == null || validScopes.length <= 0) continue;
            boolean found = false;
            for (String validScope : validScopes) {
                if (!this.getScope().equals(validScope)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new InvalidScopeException(this, tool);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Toolbox '");
        out.append(this.scope);
        out.append("' ");
        this.appendProperties(out);
        this.appendChildren(out, "tools: \n  ", "\n  ");
        return out.toString();
    }
}

