/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.ToolboxFactory;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.FileFactoryConfiguration;
import org.apache.velocity.tools.config.PropertiesFactoryConfiguration;
import org.apache.velocity.tools.config.XmlFactoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolManager {
    private VelocityEngine engine;
    private ToolboxFactory factory;
    private Toolbox application;

    public ToolManager() {
        this(true);
    }

    public ToolManager(boolean startWithDefault) {
        this.factory = startWithDefault ? FactoryConfiguration.createDefaultFactory() : new ToolboxFactory();
    }

    public void configure(FactoryConfiguration config) {
        this.application = null;
        this.factory.configure(config);
    }

    public void configure(String path) {
        this.configure(this.getConfiguration(path));
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.engine = engine;
    }

    public ToolContext createContext() {
        ToolContext context = this.engine != null ? new ToolContext(this.engine) : new ToolContext((Map<String, Object>)null);
        this.addToolboxes(context);
        return context;
    }

    public ToolContext createContext(Map<String, Object> toolProps) {
        ToolContext context;
        if (this.engine != null) {
            context = new ToolContext(this.engine);
            if (toolProps != null && !toolProps.isEmpty()) {
                for (String key : toolProps.keySet()) {
                    context.putToolProperty(key, toolProps.get(key));
                }
            }
        } else {
            context = new ToolContext(toolProps);
        }
        this.addToolboxes(context);
        return context;
    }

    protected void addToolboxes(ToolContext context) {
        if (this.hasApplicationTools()) {
            context.addToolbox(this.getApplicationToolbox());
        }
        if (this.hasRequestTools()) {
            context.addToolbox(this.getRequestToolbox());
        }
    }

    protected boolean hasRequestTools() {
        return this.factory.hasTools("request");
    }

    protected Toolbox getRequestToolbox() {
        return this.factory.createToolbox("request");
    }

    protected boolean hasApplicationTools() {
        return this.factory.hasTools("application");
    }

    protected Toolbox getApplicationToolbox() {
        if (this.application == null) {
            this.application = this.factory.createToolbox("application");
        }
        return this.application;
    }

    protected FactoryConfiguration getConfiguration(String path) {
        FileFactoryConfiguration config = null;
        if (path.endsWith(".xml")) {
            config = new XmlFactoryConfiguration();
        } else if (path.endsWith(".properties")) {
            config = new PropertiesFactoryConfiguration();
        } else {
            String msg = "Unknown configuration file type: " + path + "\nOnly .xml and .properties configuration files are supported at this time.";
            throw new UnsupportedOperationException(msg);
        }
        InputStream inputStream = this.getInputStream(path);
        try {
            config.read(inputStream);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load configuration at: " + path, ioe);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to close input stream for: " + path, ioe);
            }
        }
        return config;
    }

    protected InputStream getInputStream(String path) {
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        if (inputStream == null) {
            inputStream = this.getFileInputStream(path);
        }
        if (inputStream == null) {
            throw new ResourceNotFoundException("Could not find file at: " + path);
        }
        return inputStream;
    }

    protected InputStream getFileInputStream(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalStateException(fnfe);
            }
        }
        return null;
    }
}

