/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ConversionUtils {
    private static final int STYLE_NUMBER = 0;
    private static final int STYLE_CURRENCY = 1;
    private static final int STYLE_PERCENT = 2;
    private static final int STYLE_INTEGER = 4;

    public static NumberFormat getNumberFormat(String format, Locale locale) {
        if (format == null || locale == null) {
            return null;
        }
        NumberFormat nf = null;
        int style = ConversionUtils.getNumberStyleAsInt(format);
        nf = style < 0 ? new DecimalFormat(format, new DecimalFormatSymbols(locale)) : ConversionUtils.getNumberFormat(style, locale);
        return nf;
    }

    public static NumberFormat getNumberFormat(int numberStyle, Locale locale) {
        try {
            NumberFormat nf;
            switch (numberStyle) {
                case 0: {
                    nf = NumberFormat.getNumberInstance(locale);
                    break;
                }
                case 1: {
                    nf = NumberFormat.getCurrencyInstance(locale);
                    break;
                }
                case 2: {
                    nf = NumberFormat.getPercentInstance(locale);
                    break;
                }
                case 4: {
                    nf = NumberFormat.getIntegerInstance(locale);
                    break;
                }
                default: {
                    nf = null;
                }
            }
            return nf;
        }
        catch (Exception suppressed) {
            return null;
        }
    }

    public static int getNumberStyleAsInt(String style) {
        if (style == null || style.length() < 6 || style.length() > 8) {
            return -1;
        }
        if (style.equalsIgnoreCase("default")) {
            return 0;
        }
        if (style.equalsIgnoreCase("number")) {
            return 0;
        }
        if (style.equalsIgnoreCase("currency")) {
            return 1;
        }
        if (style.equalsIgnoreCase("percent")) {
            return 2;
        }
        if (style.equalsIgnoreCase("integer")) {
            return 4;
        }
        return -1;
    }

    public static Number toNumber(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Date) {
            return new Long(((Date)obj).getTime());
        }
        if (obj instanceof Calendar) {
            Date date = ((Calendar)obj).getTime();
            return new Long(date.getTime());
        }
        return null;
    }

    public static Number toNumber(String value, String format, Locale locale) {
        if (value == null || format == null || locale == null) {
            return null;
        }
        try {
            NumberFormat parser = ConversionUtils.getNumberFormat(format, locale);
            return parser.parse(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Number toNumber(Object value, String format, Locale locale) {
        Number number = ConversionUtils.toNumber(value);
        if (number != null) {
            return number;
        }
        return ConversionUtils.toNumber(String.valueOf(value), format, locale);
    }

    public static DateFormat getDateFormat(String format, Locale locale, TimeZone timezone) {
        if (format == null) {
            return null;
        }
        DateFormat df = null;
        if (format.endsWith("_date")) {
            String fmt = format.substring(0, format.length() - 5);
            int style = ConversionUtils.getStyleAsInt(fmt);
            df = ConversionUtils.getDateFormat(style, -1, locale, timezone);
        } else if (format.endsWith("_time")) {
            String fmt = format.substring(0, format.length() - 5);
            int style = ConversionUtils.getStyleAsInt(fmt);
            df = ConversionUtils.getDateFormat(-1, style, locale, timezone);
        } else {
            int style = ConversionUtils.getStyleAsInt(format);
            if (style < 0) {
                df = new SimpleDateFormat(format, locale);
                df.setTimeZone(timezone);
            } else {
                df = ConversionUtils.getDateFormat(style, style, locale, timezone);
            }
        }
        return df;
    }

    public static DateFormat getDateFormat(String dateStyle, String timeStyle, Locale locale, TimeZone timezone) {
        int ds = ConversionUtils.getStyleAsInt(dateStyle);
        int ts = ConversionUtils.getStyleAsInt(timeStyle);
        return ConversionUtils.getDateFormat(ds, ts, locale, timezone);
    }

    public static DateFormat getDateFormat(int dateStyle, int timeStyle, Locale locale, TimeZone timezone) {
        try {
            DateFormat df = dateStyle < 0 && timeStyle < 0 ? DateFormat.getInstance() : (timeStyle < 0 ? DateFormat.getDateInstance(dateStyle, locale) : (dateStyle < 0 ? DateFormat.getTimeInstance(timeStyle, locale) : DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale)));
            df.setTimeZone(timezone);
            return df;
        }
        catch (Exception suppressed) {
            return null;
        }
    }

    public static int getStyleAsInt(String style) {
        if (style == null || style.length() < 4 || style.length() > 7) {
            return -1;
        }
        if (style.equalsIgnoreCase("full")) {
            return 0;
        }
        if (style.equalsIgnoreCase("long")) {
            return 1;
        }
        if (style.equalsIgnoreCase("medium")) {
            return 2;
        }
        if (style.equalsIgnoreCase("short")) {
            return 3;
        }
        if (style.equalsIgnoreCase("default")) {
            return 2;
        }
        return -1;
    }

    public static Date toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof Number) {
            Date d = new Date();
            d.setTime(((Number)obj).longValue());
            return d;
        }
        return null;
    }

    public static Date toDate(Object obj, String format, Locale locale, TimeZone timezone) {
        Date date = ConversionUtils.toDate(obj);
        if (date != null) {
            return date;
        }
        return ConversionUtils.toDate(String.valueOf(obj), format, locale, timezone);
    }

    public static Date toDate(String str, String format, Locale locale, TimeZone timezone) {
        try {
            DateFormat parser = ConversionUtils.getDateFormat(format, locale, timezone);
            return parser.parse(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar toCalendar(Date date, Locale locale) {
        if (date == null) {
            return null;
        }
        Calendar cal = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        cal.setTime(date);
        cal.getTime();
        return cal;
    }
}

