/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.lang.reflect.Method;

public class ClassUtils {
    public static Class getClass(String name) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        return loader.loadClass(name);
    }

    public static Object getInstance(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return ClassUtils.getClass(classname).newInstance();
    }

    public static Method findMethod(Class clazz, String name, Class[] params) throws SecurityException {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return ClassUtils.findDeclaredMethod(clazz, name, params);
        }
    }

    public static Method findDeclaredMethod(Class clazz, String name, Class[] params) throws SecurityException {
        try {
            Method method = clazz.getDeclaredMethod(name, params);
            if (method != null) {
                method.setAccessible(true);
                return method;
            }
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        Class supclazz = clazz.getSuperclass();
        if (supclazz != null) {
            return ClassUtils.findDeclaredMethod(supclazz, name, params);
        }
        return null;
    }
}

