/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

public class NodeServletFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(NodeServletFilter.class.getName());
    private ClassLoader runtimeClassLoader;
    private Class<?> servletHostClass;
    private Object servletHost;
    private Filter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Apache Tuscany SCA WebApp Node starting...");
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            this.runtimeClassLoader = NodeLauncherUtil.webAppRuntimeClassLoader(this.getClass().getClassLoader());
            try {
                if (this.runtimeClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                }
                String className = "org.apache.tuscany.sca.implementation.node.webapp.NodeWebAppServletHost";
                this.servletHostClass = this.runtimeClassLoader != null ? Class.forName(className, true, this.runtimeClassLoader) : Class.forName(className);
                this.servletHost = this.servletHostClass.getMethod("servletHost", new Class[0]).invoke(null, new Object[0]);
                this.servletHostClass.getMethod("init", FilterConfig.class).invoke(this.servletHost, filterConfig);
                this.filter = (Filter)this.servletHost;
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error Starting SCA WebApp Node", e);
            throw new ServletException((Throwable)e);
        }
        logger.info("SCA WebApp Node started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        logger.info("Apache Tuscany WebApp Node stopping...");
        if (this.servletHost != null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                if (this.runtimeClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
                }
                this.servletHostClass.getMethod("destroy", new Class[0]).invoke(this.servletHost, new Object[0]);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error Stopping SCA WebApp Node", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        logger.info("SCA WebApp Node stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.runtimeClassLoader != null) {
                Thread.currentThread().setContextClassLoader(this.runtimeClassLoader);
            }
            this.filter.doFilter(request, response, chain);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

