/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.launcher;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.node.launcher.LauncherException;
import org.apache.tuscany.sca.node.launcher.NodeLauncherUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainManagerLauncher {
    private static final Logger logger = Logger.getLogger(DomainManagerLauncher.class.getName());

    private DomainManagerLauncher() {
    }

    public static DomainManagerLauncher newInstance() {
        return new DomainManagerLauncher();
    }

    public <T> T createDomainManager() throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(".");
    }

    public <T> T createDomainManager(String rootDirectory) throws LauncherException {
        return (T)NodeLauncherUtil.domainManager(rootDirectory);
    }

    public static void main(String[] args) throws Exception {
        logger.info("Apache Tuscany SCA Domain Manager starting...");
        DomainManagerLauncher launcher = DomainManagerLauncher.newInstance();
        Object domainManager = launcher.createDomainManager();
        try {
            domainManager.getClass().getMethod("start", new Class[0]).invoke(domainManager, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Domain Manager could not be started", e);
            throw e;
        }
        logger.info("SCA Domain Manager started.");
        logger.info("Press enter to shutdown.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            domainManager.getClass().getMethod("stop", new Class[0]).invoke(domainManager, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SCA Domain Manager could not be stopped", e);
            throw e;
        }
    }
}

