/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node.configuration.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.DeploymentComposite;
import org.apache.tuscany.sca.node.configuration.impl.DeploymentCompositeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionConfigurationImpl
implements ContributionConfiguration {
    private List<DeploymentComposite> deploymentComposites = new ArrayList<DeploymentComposite>();
    private String uri;
    private String location;

    public ContributionConfigurationImpl() {
    }

    public ContributionConfigurationImpl(String uri, String location) {
        this.uri = uri;
        this.location = location;
    }

    public ContributionConfigurationImpl(String location) {
        this.uri = location;
        this.location = location;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public ContributionConfiguration setURI(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public ContributionConfiguration setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public List<DeploymentComposite> getDeploymentComposites() {
        return this.deploymentComposites;
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(DeploymentComposite deploymentComposite) {
        this.deploymentComposites.add(deploymentComposite);
        if (this.uri != null) {
            deploymentComposite.setContributionURI(this.uri);
        }
        return this;
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(Reader reader) {
        try {
            DeploymentCompositeImpl composite = new DeploymentCompositeImpl();
            char[] buf = new char[8192];
            StringWriter sw = new StringWriter();
            int size = 0;
            while (size >= 0) {
                size = reader.read(buf);
                if (size <= 0) continue;
                sw.write(buf, 0, size);
            }
            reader.close();
            composite.setContent(sw.toString());
            return this.addDeploymentComposite(composite);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(InputStream content) {
        try {
            InputStreamReader reader = new InputStreamReader(content, "UTF-8");
            return this.addDeploymentComposite(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(String content) {
        DeploymentCompositeImpl composite = new DeploymentCompositeImpl();
        composite.setContent(content);
        return this.addDeploymentComposite(composite);
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(URI location) {
        DeploymentCompositeImpl composite = new DeploymentCompositeImpl();
        composite.setLocation(location.toString());
        return this.addDeploymentComposite(composite);
    }

    @Override
    public ContributionConfiguration addDeploymentComposite(URL location) {
        DeploymentCompositeImpl composite = new DeploymentCompositeImpl();
        composite.setLocation(location.toString());
        return this.addDeploymentComposite(composite);
    }
}

