/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.tuscany.sca.node.Client;
import org.apache.tuscany.sca.node.Contribution;
import org.apache.tuscany.sca.node.Node;
import org.oasisopen.sca.CallableReference;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public abstract class NodeFactory {
    public static NodeFactory newInstance() {
        NodeFactory scaNodeFactory = null;
        try {
            try {
                Class<?> discoveryClass = Class.forName("org.apache.tuscany.sca.extensibility.ServiceDiscovery");
                Object instance = discoveryClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Object factoryDeclaration = discoveryClass.getMethod("getFirstServiceDeclaration", String.class).invoke(instance, NodeFactory.class.getName());
                if (factoryDeclaration != null) {
                    Class factoryImplClass = (Class)factoryDeclaration.getClass().getMethod("loadClass", new Class[0]).invoke(factoryDeclaration, new Object[0]);
                    scaNodeFactory = (NodeFactory)factoryImplClass.newInstance();
                    return scaNodeFactory;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            String className = "org.apache.tuscany.sca.node.impl.NodeFactoryImpl";
            Class<?> cls = Class.forName(className);
            scaNodeFactory = (NodeFactory)cls.newInstance();
            return scaNodeFactory;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public abstract Node createNode();

    public abstract Node createNode(String var1);

    public abstract Node createNode(String var1, Contribution ... var2);

    public abstract Node createNode(String var1, String var2, Contribution ... var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeProxy
    implements Node,
    Client {
        private Object node;

        private NodeProxy(Object node) {
            this.node = node;
        }

        public static <T> T createProxy(Class<T> type, Object node) {
            try {
                return type.getDeclaredConstructor(Object.class).newInstance(node);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
            try {
                return (R)((CallableReference)this.node.getClass().getMethod("cast", Object.class).invoke(this.node, target));
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> B getService(Class<B> businessInterface, String serviceName) {
            try {
                return (B)this.node.getClass().getMethod("getService", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String serviceName) {
            try {
                return (ServiceReference)this.node.getClass().getMethod("getServiceReference", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public void start() {
            try {
                this.node.getClass().getMethod("start", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        @Override
        public void stop() {
            try {
                this.node.getClass().getMethod("stop", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        @Override
        public void destroy() {
            try {
                this.node.getClass().getMethod("destroy", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        private static void handleException(Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new RuntimeException(ex);
        }
    }
}

