/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionLocationHelper {
    public static String getContributionLocation(final Class<?> anchorClass) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return anchorClass.getProtectionDomain().getCodeSource().getLocation();
            }
        });
        String uri = url.toString();
        return uri;
    }

    public static String getContributionLocation(String resourceName) {
        return ContributionLocationHelper.getContributionLocation(null, resourceName);
    }

    public static String getContributionLocation(ClassLoader classLoader, String resourceName) {
        URL resourceURL;
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        if ((resourceURL = ContributionLocationHelper.getResource(classLoader, resourceName)) == null) {
            return null;
        }
        String location = null;
        String url = resourceURL.toExternalForm();
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            if (url.endsWith(resourceName)) {
                location = url.substring(0, url.lastIndexOf(resourceName));
            }
        } else if ("jar".equals(protocol) || "wsjar".equals(protocol) || "zip".equals(protocol)) {
            location = url.substring(protocol.length() + 1, url.lastIndexOf("!/"));
        }
        return location;
    }

    private static URL getResource(final ClassLoader classLoader, final String compositeURI) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return classLoader.getResource(compositeURI);
            }
        });
    }
}

