/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.java2wsdl.plugin;

import java.util.Hashtable;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tuscany.tools.java2wsdl.generate.Java2WSDLGeneratorFactory;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLGeneratorMojo
extends AbstractMojo {
    private String sourceClassName;
    private String targetLocation;
    private String wsdlFilename;
    String[] classpaths;
    private String serviceName;
    private String bindingStyle;
    private String bindingUse;
    private String soapAddress;

    public void execute() throws MojoExecutionException {
        try {
            Java2WSDLGeneratorFactory.getInstance().createGenerator().generateWSDL(this.createOptionsMap());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception in Java2WSDL Maven Plugin ", e);
        }
    }

    protected Map createOptionsMap() {
        Hashtable<String, Java2WSDLCommandLineOption> optionsMap = new Hashtable<String, Java2WSDLCommandLineOption>();
        optionsMap.put("cn", new Java2WSDLCommandLineOption("cn", new String[]{this.sourceClassName}));
        if (this.targetLocation != null) {
            optionsMap.put("o", new Java2WSDLCommandLineOption("o", new String[]{this.targetLocation}));
        }
        if (this.wsdlFilename != null) {
            optionsMap.put("of", new Java2WSDLCommandLineOption("of", new String[]{this.wsdlFilename}));
        }
        if (this.classpaths != null && this.classpaths.length > 0) {
            optionsMap.put("cp", new Java2WSDLCommandLineOption("cp", this.classpaths));
        }
        if (this.serviceName != null) {
            optionsMap.put("sn", new Java2WSDLCommandLineOption("sn", new String[]{this.serviceName}));
        }
        if (this.bindingStyle != null) {
            optionsMap.put("st", new Java2WSDLCommandLineOption("st", new String[]{this.bindingStyle}));
        }
        if (this.bindingUse != null) {
            optionsMap.put("u", new Java2WSDLCommandLineOption("u", new String[]{this.bindingUse}));
        }
        if (this.soapAddress != null) {
            optionsMap.put("l", new Java2WSDLCommandLineOption("l", new String[]{this.soapAddress}));
        }
        return optionsMap;
    }
}

