/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;

class WidgetImplementationInvoker
implements Invoker {
    private RuntimeComponent component;
    private ComponentJavaScriptGenerator javaScriptGenerator;
    private String widgetName;
    private String widgetFolderURL;
    private String widgetLocationURL;

    WidgetImplementationInvoker(RuntimeComponent component, ComponentJavaScriptGenerator javaScriptGenerator, String widgetName, String widgetFolderURL, String widgetLocationURL) {
        this.component = component;
        this.javaScriptGenerator = javaScriptGenerator;
        this.widgetName = widgetName + ".js";
        this.widgetFolderURL = widgetFolderURL;
        this.widgetLocationURL = widgetLocationURL;
    }

    public Message invoke(Message msg) {
        HTTPContext bindingContext = (HTTPContext)msg.getBindingContext();
        HttpServletRequest request = bindingContext.getHttpRequest();
        String pathInfo = request.getPathInfo();
        String path = null;
        if (pathInfo != null) {
            try {
                path = URLDecoder.decode(pathInfo, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        String id = path == null ? "" : path.substring(1);
        try {
            if (id.length() == 0) {
                URL url = new URL(this.widgetLocationURL);
                WidgetImplementationInvoker.writeResponse(bindingContext, url.openStream());
            } else if (id.equals(this.widgetName)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bos);
                this.javaScriptGenerator.generateJavaScriptCode(this.component, pw);
                ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                WidgetImplementationInvoker.writeResponse(bindingContext, is);
            } else {
                URL url = new URL(this.widgetFolderURL + '/' + id);
                InputStream is = url.openStream();
                WidgetImplementationInvoker.writeResponse(bindingContext, is);
            }
        }
        catch (MalformedURLException e) {
            msg.setFaultBody((Object)e);
        }
        catch (IOException e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    private static void writeResponse(HTTPContext bindingContext, InputStream is) throws IOException {
        int n;
        ServletOutputStream os = bindingContext.getHttpResponse().getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }
}

