/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactory;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactoryExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WidgetComponentScriptGenerator {
    public static InputStream generateWidgetCode(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories) throws IOException, URISyntaxException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        WidgetComponentScriptGenerator.generateWidgetCode(component, javascriptProxyFactories, pw);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public static void generateWidgetCode(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories, OutputStream os) throws IOException, URISyntaxException {
        PrintWriter pw = new PrintWriter(os);
        WidgetComponentScriptGenerator.generateWidgetCode(component, javascriptProxyFactories, pw);
    }

    public static void generateWidgetCode(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories, PrintWriter pw) throws IOException, URISyntaxException {
        pw.println();
        pw.println("/* Apache Tuscany SCA Widget header */");
        pw.println();
        HashMap<String, Boolean> bindingClientProcessed = new HashMap<String, Boolean>();
        for (ComponentReference reference : component.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                Boolean processedFlag;
                JavascriptProxyFactory jsProxyFactory = javascriptProxyFactories.getProxyFactory(binding.getClass());
                String bindingProxyName = jsProxyFactory.getJavascriptProxyFile();
                if (bindingProxyName == null || (processedFlag = (Boolean)bindingClientProcessed.get(bindingProxyName)) != null && processedFlag.booleanValue()) continue;
                WidgetComponentScriptGenerator.generateJavaScriptBindingProxy(jsProxyFactory, pw);
                bindingClientProcessed.put(bindingProxyName, Boolean.TRUE);
            }
        }
        pw.println();
        pw.println("/* Tuscany Reference/Property injection code */");
        pw.println();
        WidgetComponentScriptGenerator.generateJavaScriptNamespace(pw);
        pw.println();
        WidgetComponentScriptGenerator.generateJavaScriptPropertyFunction(component, pw);
        pw.println();
        WidgetComponentScriptGenerator.generateJavaScriptReferenceFunction(component, javascriptProxyFactories, pw);
        pw.println();
        pw.println("/** End of Apache Tuscany SCA Widget */");
        pw.println();
        pw.flush();
        pw.close();
    }

    private static void generateJavaScriptBindingProxy(JavascriptProxyFactory javascriptProxyFactory, PrintWriter pw) throws IOException {
        InputStream is = javascriptProxyFactory.getJavascriptProxyFileAsStream();
        if (is != null) {
            int i;
            while ((i = is.read()) != -1) {
                pw.write(i);
            }
        }
        pw.println();
        pw.println();
    }

    private static void generateJavaScriptNamespace(PrintWriter pw) throws IOException {
        pw.println("if (!tuscany) { \nvar tuscany = {}; \n}");
        pw.println("if (!tuscany.sca) { \ntuscany.sca = {}; \n}");
    }

    private static void generateJavaScriptPropertyFunction(RuntimeComponent component, PrintWriter pw) throws IOException {
        pw.println("tuscany.sca.propertyMap = new String();");
        for (ComponentProperty property : component.getProperties()) {
            String propertyName = property.getName();
            pw.println("tuscany.sca.propertyMap." + propertyName + " = \"" + WidgetComponentScriptGenerator.getPropertyValue(property) + "\"");
        }
        pw.println("tuscany.sca.Property = function (name) {");
        pw.println("    return tuscany.sca.propertyMap[name];");
        pw.println("}");
    }

    private static String getPropertyValue(ComponentProperty property) {
        Document doc = (Document)property.getValue();
        Element rootElement = doc.getDocumentElement();
        String value = null;
        if (rootElement.getChildNodes().getLength() > 0) {
            value = rootElement.getChildNodes().item(0).getTextContent();
        }
        return value;
    }

    private static void generateJavaScriptReferenceFunction(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories, PrintWriter pw) throws IOException, URISyntaxException {
        pw.println("tuscany.sca.referenceMap = new Object();");
        for (ComponentReference reference : component.getReferences()) {
            Binding binding = (Binding)reference.getBindings().get(0);
            if (binding == null) continue;
            String referenceName = reference.getName();
            JavascriptProxyFactory jsProxyFactory = javascriptProxyFactories.getProxyFactory(binding.getClass());
            pw.println("tuscany.sca.referenceMap." + referenceName + " = new " + jsProxyFactory.createJavascriptReference(reference) + ";");
        }
        pw.println("tuscany.sca.Reference = function (name) {");
        pw.println("    return tuscany.sca.referenceMap[name];");
        pw.println("}");
    }
}

