/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.implementation.widget.provider.WidgetProxyHelper;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class WidgetImplementationInvoker
implements Invoker {
    private RuntimeComponent component;
    private String widgetName;
    private String widgetFolderURL;
    private String widgetLocationURL;

    WidgetImplementationInvoker(RuntimeComponent component, String widgetName, String widgetFolderURL, String widgetLocationURL) {
        this.component = component;
        this.widgetName = widgetName + ".js";
        this.widgetFolderURL = widgetFolderURL;
        this.widgetLocationURL = widgetLocationURL;
    }

    public Message invoke(Message msg) {
        String id = (String)((Object[])msg.getBody())[0];
        try {
            if (id.length() == 0) {
                URL url = new URL(this.widgetLocationURL);
                InputStream is = url.openStream();
                msg.setBody((Object)is);
            } else if (id.equals(this.widgetName)) {
                InputStream is = this.generateWidgetCode();
                msg.setBody((Object)is);
            } else {
                URL url = new URL(this.widgetFolderURL + '/' + id);
                InputStream is = url.openStream();
                msg.setBody((Object)is);
            }
        }
        catch (MalformedURLException e) {
            msg.setFaultBody((Object)e);
        }
        catch (URISyntaxException e) {
            msg.setFaultBody((Object)e);
        }
        catch (IOException e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }

    private InputStream generateWidgetCode() throws IOException, URISyntaxException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        pw.println();
        pw.println("/* Apache Tuscany SCA Widget header */");
        pw.println();
        HashMap<String, Boolean> bindingClientProcessed = new HashMap<String, Boolean>();
        for (ComponentReference reference : this.component.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                String[] bindingProxyNames = WidgetProxyHelper.getJavaScriptProxyFile(binding.getClass().getName());
                if (bindingProxyNames == null) continue;
                for (int i = 0; i < bindingProxyNames.length; ++i) {
                    Boolean processedFlag;
                    String bindingProxyName = bindingProxyNames[i];
                    if (bindingProxyName == null || (processedFlag = (Boolean)bindingClientProcessed.get(bindingProxyName)) != null && processedFlag.booleanValue()) continue;
                    this.generateJavaScriptBindingProxy(pw, bindingProxyName);
                    bindingClientProcessed.put(bindingProxyName, Boolean.TRUE);
                }
            }
        }
        this.generateJavaScriptPropertyFunction(pw);
        this.generateJavaScriptReferenceFunction(pw);
        pw.println();
        pw.println("/** End of Apache Tuscany SCA Widget */");
        pw.println();
        pw.flush();
        pw.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    private void generateJavaScriptBindingProxy(PrintWriter pw, String bindingProxyName) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(bindingProxyName);
        if (is != null) {
            int i;
            while ((i = is.read()) != -1) {
                pw.write(i);
            }
        }
        pw.println();
        pw.println();
    }

    private void generateJavaScriptPropertyFunction(PrintWriter pw) throws IOException {
        pw.println("var propertyMap = new String();");
        for (ComponentProperty property : this.component.getProperties()) {
            String propertyName = property.getName();
            pw.println("propertyMap." + propertyName + " = \"" + this.getPropertyValue(property) + "\"");
        }
        pw.println("function Property(name) {");
        pw.println("    return propertyMap[name];");
        pw.println("}");
    }

    private String getPropertyValue(ComponentProperty property) {
        Document doc = (Document)property.getValue();
        Element rootElement = doc.getDocumentElement();
        String value = null;
        if (rootElement.getChildNodes().getLength() > 0) {
            value = rootElement.getChildNodes().item(0).getTextContent();
        }
        return value;
    }

    private void generateJavaScriptReferenceFunction(PrintWriter pw) throws IOException, URISyntaxException {
        pw.println("var referenceMap = new Object();");
        for (ComponentReference reference : this.component.getReferences()) {
            String proxyClient;
            String referenceName = reference.getName();
            Binding binding = (Binding)reference.getBindings().get(0);
            if (binding == null || (proxyClient = WidgetProxyHelper.getJavaScriptProxyClient(binding.getClass().getName())) == null) continue;
            URI targetURI = URI.create(binding.getURI());
            String targetPath = targetURI.getPath();
            if (proxyClient.equals("JSONRpcClient")) {
                pw.println("referenceMap." + referenceName + " = new " + proxyClient + "(\"" + targetPath + "\").Service;");
                continue;
            }
            pw.println("referenceMap." + referenceName + " = new " + proxyClient + "(\"" + targetPath + "\");");
        }
        pw.println("function Reference(name) {");
        pw.println("    return referenceMap[name];");
        pw.println("}");
    }
}

