/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.xml.ConfiguredOperationProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.xml.JavaImplementationConstants;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImplementationProcessor
implements StAXArtifactProcessor<JavaImplementation>,
JavaImplementationConstants {
    private AssemblyFactory assemblyFactory;
    private PolicyFactory policyFactory;
    private ExtensionFactory extensionFactory;
    private JavaImplementationFactory javaFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private ConfiguredOperationProcessor configuredOperationProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private Monitor monitor;

    public JavaImplementationProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.extensionFactory = (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class);
        this.javaFactory = (JavaImplementationFactory)modelFactories.getFactory(JavaImplementationFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.intentAttachPointTypeFactory = (IntentAttachPointTypeFactory)modelFactories.getFactory(IntentAttachPointTypeFactory.class);
        this.monitor = monitor;
        this.configuredOperationProcessor = new ConfiguredOperationProcessor(modelFactories, this.monitor);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-javaxml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "impl-javaxml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public JavaImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        JavaImplementation javaImplementation = this.javaFactory.createJavaImplementation();
        javaImplementation.setUnresolved(true);
        javaImplementation.setName(reader.getAttributeValue(null, "class"));
        this.policyProcessor.readPolicies((Object)javaImplementation, reader);
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || "http://www.osoa.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI()) || "http://tuscany.apache.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : this.extensionFactory.createExtension(attributeName, attributeValue, true);
            javaImplementation.getAttributeExtensions().add(attributeExtension);
        }
        ConfiguredOperation confOp = null;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (!Constants.OPERATION_QNAME.equals(reader.getName()) || (confOp = this.configuredOperationProcessor.read(reader)) == null) break;
                    ((OperationsConfigurator)javaImplementation).getConfiguredOperations().add(confOp);
                }
            }
            if (event != 2 || !IMPLEMENTATION_JAVA_QNAME.equals(reader.getName())) continue;
            break;
        }
        return javaImplementation;
    }

    public void write(JavaImplementation javaImplementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.policyProcessor.writePolicyPrefixes((Object)javaImplementation, writer);
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "implementation.java");
        this.policyProcessor.writePolicyAttributes((Object)javaImplementation, writer);
        if (javaImplementation.getName() != null) {
            writer.writeAttribute("class", javaImplementation.getName());
        }
        for (Extension extension : javaImplementation.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write((Object)extension, writer);
        }
        writer.writeEndElement();
    }

    public void resolve(JavaImplementation javaImplementation, ModelResolver resolver) throws ContributionResolveException {
        ClassReference classReference = new ClassReference(javaImplementation.getName());
        Class javaClass = (classReference = (ClassReference)resolver.resolveModel(ClassReference.class, (Object)classReference)).getJavaClass();
        if (javaClass == null) {
            this.error("ClassNotFoundException", (Object)resolver, javaImplementation.getName());
            return;
        }
        javaImplementation.setJavaClass(javaClass);
        try {
            this.javaFactory.createJavaImplementation(javaImplementation, javaImplementation.getJavaClass());
        }
        catch (IntrospectionException e) {
            ContributionResolveException ce = new ContributionResolveException((Throwable)e);
            this.error("ContributionResolveException", (Object)this.javaFactory, (Exception)ce);
            return;
        }
        javaImplementation.setUnresolved(false);
        this.mergeComponentType(resolver, javaImplementation);
        if (javaImplementation.getServices().isEmpty()) {
            javaImplementation.getServices().add(this.assemblyFactory.createService());
        }
    }

    private JavaElementImpl getMemeber(JavaImplementation impl, String name, Class<?> type) {
        String setter = JavaIntrospectionHelper.toSetter((String)name);
        try {
            Method method = impl.getJavaClass().getDeclaredMethod(setter, type);
            int mod = method.getModifiers();
            if ((Modifier.isPublic(mod) || Modifier.isProtected(mod)) && !Modifier.isStatic(mod)) {
                return new JavaElementImpl(method, 0);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = impl.getJavaClass().getDeclaredField(name);
                int mod = field.getModifiers();
                if ((Modifier.isPublic(mod) || Modifier.isProtected(mod)) && !Modifier.isStatic(mod)) {
                    return new JavaElementImpl(field);
                }
            }
            catch (NoSuchFieldException e1) {
                // empty catch block
            }
        }
        return null;
    }

    private void mergeComponentType(ModelResolver resolver, JavaImplementation impl) {
        ComponentType componentType = this.getComponentType(resolver, impl);
        if (componentType != null && !componentType.isUnresolved()) {
            HashMap<String, Reference> refMap = new HashMap<String, Reference>();
            for (Reference ref : impl.getReferences()) {
                refMap.put(ref.getName(), ref);
            }
            for (Reference reference : componentType.getReferences()) {
                refMap.put(reference.getName(), reference);
            }
            impl.getReferences().clear();
            impl.getReferences().addAll(refMap.values());
            Map refMembers = impl.getReferenceMembers();
            for (Reference ref : impl.getReferences()) {
                JavaElementImpl e;
                Interface i;
                if (ref.getInterfaceContract() == null || !((i = ref.getInterfaceContract().getInterface()) instanceof JavaInterface)) continue;
                Class type = ((JavaInterface)i).getJavaClass();
                if (refMembers.containsKey(ref.getName()) || (e = this.getMemeber(impl, ref.getName(), type)) == null) continue;
                refMembers.put(ref.getName(), e);
            }
            HashMap<String, Service> serviceMap = new HashMap<String, Service>();
            for (Service svc : impl.getServices()) {
                serviceMap.put(svc.getName(), svc);
            }
            for (Service service : componentType.getServices()) {
                serviceMap.put(service.getName(), service);
            }
            impl.getServices().clear();
            impl.getServices().addAll(serviceMap.values());
            HashMap<String, Property> propMap = new HashMap<String, Property>();
            for (Property prop : impl.getProperties()) {
                propMap.put(prop.getName(), prop);
            }
            for (Property property : componentType.getProperties()) {
                propMap.put(property.getName(), property);
            }
            impl.getProperties().clear();
            impl.getProperties().addAll(propMap.values());
            if (componentType.getConstrainingType() != null) {
                impl.setConstrainingType(componentType.getConstrainingType());
            }
        }
    }

    private ComponentType getComponentType(ModelResolver resolver, JavaImplementation impl) {
        String className = impl.getJavaClass().getName();
        String componentTypeURI = className.replace('.', '/') + ".componentType";
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        componentType.setURI(componentTypeURI);
        componentType = (ComponentType)resolver.resolveModel(ComponentType.class, (Object)componentType);
        if (!componentType.isUnresolved()) {
            return componentType;
        }
        return null;
    }

    public QName getArtifactType() {
        return IMPLEMENTATION_JAVA_QNAME;
    }

    public Class<JavaImplementation> getModelType() {
        return JavaImplementation.class;
    }
}

