/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.ode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;

public class BPELODEDeployFile {
    private final Log __log = LogFactory.getLog(this.getClass());
    static final String DEPLOY_ELEMENT_START = "<deploy xmlns=\"http://www.apache.org/ode/schemas/dd/2007/03\"";
    static final String DEPLOY_ENDELEMENT = "</deploy>";
    static final String PROCESS_NAMESPACE_DECL = "xmlns:tns=";
    static final String SERVICE_NAMESPACE = "xmlns:tus=\"http://tuscany.apache.org\"";
    static final String PROCESS_ELEMENT_START = "<process name=\"tns:";
    static final String PROCESS_ELEMENT_END = "\">";
    static final String PROCESS_ENDELEMENT = "</process>";
    static final String ACTIVE_ELEMENT = "<active>true</active>";
    static final String PROVIDE_ELEMENT_START = "<provide partnerLink=\"";
    static final String PROVIDE_ELEMENT_END = "\">";
    static final String PROVIDE_ENDELEMENT = "</provide>";
    static final String SERVICE_ELEMENT_START = "<service name=\"tus:";
    static final String SERVICE_ELEMENT_PORT = "\" port=\"";
    static final String SERVICE_ELEMENT_END = "Port\"/>";
    static final String INVOKE_ELEMENT_START = "<invoke partnerLink=\"";
    static final String INVOKE_ELEMENT_END = "\">";
    static final String INVOKE_ENDELEMENT = "</invoke>";
    static final String DEPLOY_FILENAME = "deploy.xml";
    private BPELImplementation implementation;

    public BPELODEDeployFile(BPELImplementation theImplementation) {
        this.implementation = theImplementation;
    }

    public void writeDeployfile() throws IOException {
        File theDirectory = this.getDirectory();
        File deployFile = new File(theDirectory, DEPLOY_FILENAME);
        new FileOutputStream(deployFile);
        PrintStream theStream = new PrintStream(new FileOutputStream(deployFile));
        try {
            this.constructDeployXML(theStream);
            if (theStream.checkError()) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to write data to deploy file" + deployFile.getPath());
        }
        finally {
            theStream.close();
        }
    }

    public void constructDeployXML(PrintStream stream) {
        stream.println(DEPLOY_ELEMENT_START);
        QName process = this.implementation.getProcess();
        String processNamespace = process.getNamespaceURI();
        stream.println("xmlns:tns=\"" + processNamespace + "\"");
        stream.println("xmlns:tus=\"http://tuscany.apache.org\">");
        stream.println(PROCESS_ELEMENT_START + process.getLocalPart() + "\">");
        stream.println(ACTIVE_ELEMENT);
        ComponentType componentType = this.implementation.getComponentType();
        List theServices = componentType.getServices();
        for (Service service : theServices) {
            String serviceName = service.getName();
            stream.println(PROVIDE_ELEMENT_START + serviceName + "\">");
            stream.println(SERVICE_ELEMENT_START + serviceName + SERVICE_ELEMENT_PORT + serviceName + SERVICE_ELEMENT_END);
            stream.println(PROVIDE_ENDELEMENT);
        }
        List theReferences = componentType.getReferences();
        for (Reference reference : theReferences) {
            String referenceName = reference.getName();
            stream.println(INVOKE_ELEMENT_START + referenceName + "\">");
            stream.println(SERVICE_ELEMENT_START + referenceName + SERVICE_ELEMENT_PORT + referenceName + SERVICE_ELEMENT_END);
            stream.println(INVOKE_ENDELEMENT);
        }
        stream.println(PROCESS_ENDELEMENT);
        stream.println(DEPLOY_ENDELEMENT);
    }

    private File getDirectory() {
        File theDir = this.getBPELFile().getParentFile();
        return theDir;
    }

    private File getBPELFile() {
        URL fileURL = this.implementation.getProcessDefinition().getLocation();
        try {
            File theProcess = new File(fileURL.toURI());
            return theProcess;
        }
        catch (Exception e) {
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("Exception converting BPEL file URL to an URI: " + e));
            }
            return null;
        }
    }
}

