/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tuscany.sca.endpoint.tribes.AbstractReplicatedMap;

public class ReplicatedMap
extends AbstractReplicatedMap
implements RpcCallback,
ChannelListener,
MembershipListener {
    private static final long serialVersionUID = -6318779627600581121L;
    protected static Log log = LogFactory.getLog(ReplicatedMap.class);

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, float loadFactor, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, loadFactor, 2, cls);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, 0.75f, 2, cls);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, 16, 0.75f, 2, cls);
    }

    protected int getStateMessageType() {
        return 10;
    }

    protected Member[] publishEntryInfo(Object key, Object value) throws ChannelException {
        if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
            return new Member[0];
        }
        Member[] members = this.getMapMembers();
        if (members == null || members.length == 0) {
            return new Member[0];
        }
        AbstractReplicatedMap.MapMessage msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 9, false, (Serializable)key, (Serializable)value, null, this.channel.getLocalMember(false), members);
        this.getChannel().send(members, (Serializable)msg, this.getChannelSendOptions());
        return members;
    }

    public Object get(Object key) {
        AbstractReplicatedMap.MapEntry entry = super.getInternal(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Requesting id:" + key + " entry:" + entry));
        }
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberDisappeared(Member member) {
        boolean removed = false;
        Map map = this.mapMembers;
        synchronized (map) {
            boolean bl = removed = this.mapMembers.remove(member) != null;
            if (!removed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member[" + member + "] disappeared, but was not present in the map."));
                }
                return;
            }
        }
        Iterator<Map.Entry<Object, Object>> i = super.entrySetFull().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            AbstractReplicatedMap.MapEntry entry = super.getInternal(e.getKey());
            if (entry == null || !member.equals(entry.getPrimary())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"[2] Primary disappeared");
            }
            i.remove();
        }
    }
}

