/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.io.Serializable;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tuscany.sca.endpoint.tribes.AbstractReplicatedMap;

public class ReplicatedMap
extends AbstractReplicatedMap
implements RpcCallback,
ChannelListener,
MembershipListener {
    private static final long serialVersionUID = -6318779627600581121L;
    protected static Log log = LogFactory.getLog(ReplicatedMap.class);

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, float loadFactor, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, loadFactor, 2, cls);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, initialCapacity, 0.75f, 2, cls);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner owner, Channel channel, long timeout, String mapContextName, ClassLoader[] cls) {
        super(owner, channel, timeout, mapContextName, 16, 0.75f, 2, cls);
    }

    protected int getStateMessageType() {
        return 10;
    }

    protected Member[] publishEntryInfo(Object key, Object value, Member[] backupNodes) throws ChannelException {
        if (!(key instanceof Serializable) || !(value instanceof Serializable)) {
            return new Member[0];
        }
        Member[] backup = this.getMapMembers();
        if (backup == null || backup.length == 0) {
            return null;
        }
        Member[] members = backup;
        if (backupNodes != null) {
            members = this.getMapMembersExcl(backupNodes);
        }
        AbstractReplicatedMap.MapMessage msg = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 9, false, (Serializable)key, (Serializable)value, null, this.channel.getLocalMember(false), backup);
        this.getChannel().send(members, (Serializable)msg, this.getChannelSendOptions());
        return backup;
    }
}

