/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.endpoint.tribes;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.membership.StaticMember;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.endpoint.tribes.AbstractReplicatedMap;
import org.apache.tuscany.sca.endpoint.tribes.MapStore;
import org.apache.tuscany.sca.endpoint.tribes.ReplicatedMap;
import org.apache.tuscany.sca.runtime.EndpointListener;
import org.apache.tuscany.sca.runtime.EndpointRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedEndpointRegistry
implements EndpointRegistry,
LifeCycleListener,
MapStore.MapListener {
    private static final Logger logger = Logger.getLogger(ReplicatedEndpointRegistry.class.getName());
    private static final String MULTICAST_ADDRESS = "228.0.0.100";
    private static final int MULTICAST_PORT = 50000;
    private int port = 50000;
    private String address = "228.0.0.100";
    private String bind = null;
    private int timeout = 50;
    private static final String DEFAULT_DOMAIN_URI = "http://tuscany.apache.org/sca/1.1/domains/default";
    private String domainURI = "http://tuscany.apache.org/sca/1.1/domains/default";
    private List<EndpointReference> endpointreferences = new CopyOnWriteArrayList<EndpointReference>();
    private List<EndpointListener> listeners = new CopyOnWriteArrayList<EndpointListener>();
    private ExtensionPointRegistry registry;
    private ReplicatedMap map;
    private static List<URI> staticRoutes;
    private String id;

    private static final Channel createChannel(String address, int port, String bindAddress) {
        GroupChannel channel = new GroupChannel();
        McastService mcastService = (McastService)channel.getMembershipService();
        mcastService.setPort(port);
        mcastService.setAddress(address);
        if (bindAddress != null) {
            mcastService.setBind(bindAddress);
        } else {
            mcastService.setBind(ReplicatedEndpointRegistry.getBindAddress());
        }
        return channel;
    }

    public ReplicatedEndpointRegistry(ExtensionPointRegistry registry, Map<String, String> attributes, String domainRegistryURI, String domainURI) {
        this.registry = registry;
        this.domainURI = domainURI;
        this.id = "[" + System.identityHashCode(this) + "]";
        this.getParameters(attributes, domainRegistryURI);
    }

    private Map<String, String> getParameters(Map<String, String> attributes, String domainRegistryURI) {
        String[] params;
        int index;
        URI uri;
        HashMap<String, String> map = new HashMap<String, String>();
        if (attributes != null) {
            map.putAll(attributes);
        }
        if ((uri = URI.create(domainRegistryURI)).getHost() != null) {
            map.put("address", uri.getHost());
        }
        if (uri.getPort() != -1) {
            map.put("port", String.valueOf(uri.getPort()));
        }
        if ((index = domainRegistryURI.indexOf(63)) == -1) {
            this.setConfig(map);
            return map;
        }
        String query = domainRegistryURI.substring(index + 1);
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        String[] stringArray = params = query.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            index = param.indexOf(61);
            if (index != -1) {
                map.put(param.substring(0, index), param.substring(index + 1));
            }
            ++n2;
        }
        this.setConfig(map);
        return map;
    }

    private void setConfig(Map<String, String> attributes) {
        String routesStr;
        String address;
        String portStr = attributes.get("port");
        if (portStr != null) {
            this.port = Integer.parseInt(portStr);
            if (this.port == -1) {
                this.port = 50000;
            }
        }
        if ((address = attributes.get("address")) == null) {
            address = MULTICAST_ADDRESS;
        }
        this.bind = attributes.get("bind");
        String timeoutStr = attributes.get("timeout");
        if (timeoutStr != null) {
            this.timeout = Integer.parseInt(timeoutStr);
        }
        if ((routesStr = attributes.get("routes")) != null) {
            StringTokenizer st = new StringTokenizer(routesStr);
            staticRoutes = new ArrayList<URI>();
            while (st.hasMoreElements()) {
                staticRoutes.add(URI.create("tcp://" + st.nextToken()));
            }
        }
    }

    public void start() {
        if (this.map != null) {
            throw new IllegalStateException("The registry has already been started");
        }
        this.map = new ReplicatedMap(null, ReplicatedEndpointRegistry.createChannel(this.address, this.port, this.bind), this.timeout, this.domainURI, new ClassLoader[]{ReplicatedEndpointRegistry.class.getClassLoader()});
        this.map.addListener(this);
        if (staticRoutes != null) {
            StaticMembershipInterceptor smi = new StaticMembershipInterceptor();
            for (URI staticRoute : staticRoutes) {
                StaticMember member;
                try {
                    member = new StaticMember(staticRoute.getHost(), staticRoute.getPort(), 5000L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                smi.addStaticMember((Member)member);
                logger.info("Added static route: " + staticRoute.getHost() + ":" + staticRoute.getPort());
            }
            smi.setLocalMember(this.map.getChannel().getLocalMember(false));
            this.map.getChannel().addInterceptor((ChannelInterceptor)smi);
        }
        try {
            this.map.getChannel().start(15);
        }
        catch (ChannelException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() {
        if (this.map != null) {
            this.map.removeListener(this);
            Channel channel = this.map.getChannel();
            this.map.breakdown();
            try {
                channel.stop(15);
            }
            catch (ChannelException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.map = null;
        }
    }

    public void addEndpoint(Endpoint endpoint) {
        this.map.put(endpoint.getURI(), endpoint);
        logger.info("Add endpoint - " + endpoint);
    }

    public void addEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.add(endpointReference);
        logger.fine("Add endpoint reference - " + endpointReference);
    }

    public void addListener(EndpointListener listener) {
        this.listeners.add(listener);
    }

    private String[] parse(String uri) {
        String[] names = new String[3];
        int index = uri.lastIndexOf(35);
        if (index == -1) {
            names[0] = uri;
        } else {
            names[0] = uri.substring(0, index);
            String str = uri.substring(index + 1);
            if (str.startsWith("service-binding(") && str.endsWith(")")) {
                String[] parts = (str = str.substring("service-binding(".length(), str.length() - 1)).split("/");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid service-binding URI: " + uri);
                }
                names[1] = parts[0];
                names[2] = parts[1];
            } else if (str.startsWith("service(") && str.endsWith(")")) {
                names[1] = str = str.substring("service(".length(), str.length() - 1);
            } else {
                throw new IllegalArgumentException("Invalid component/service/binding URI: " + uri);
            }
        }
        return names;
    }

    private boolean matches(String target, String uri) {
        String[] parts1 = this.parse(target);
        String[] parts2 = this.parse(uri);
        int i = 0;
        while (i < parts1.length) {
            if (parts1[i] != null && !parts1[i].equals(parts2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<Endpoint> findEndpoint(EndpointReference endpointReference) {
        ArrayList<Endpoint> foundEndpoints = new ArrayList<Endpoint>();
        logger.fine("Find endpoint for reference - " + endpointReference);
        if (endpointReference.getReference() != null) {
            Endpoint targetEndpoint = endpointReference.getTargetEndpoint();
            for (Object v : this.map.values()) {
                Endpoint endpoint = (Endpoint)v;
                logger.fine("Matching against - " + endpoint);
                if (!this.matches(targetEndpoint.getURI(), endpoint.getURI())) continue;
                AbstractReplicatedMap.MapEntry entry = this.map.getInternal(endpoint.getURI());
                if (!this.isLocal(entry)) {
                    endpoint.setRemote(true);
                }
                endpoint.setExtensionPointRegistry(this.registry);
                foundEndpoints.add(endpoint);
                logger.fine("Found endpoint with matching service  - " + endpoint);
            }
        }
        return foundEndpoints;
    }

    private boolean isLocal(AbstractReplicatedMap.MapEntry entry) {
        return entry.getPrimary().equals(this.map.getChannel().getLocalMember(false));
    }

    public List<EndpointReference> findEndpointReference(Endpoint endpoint) {
        return this.endpointreferences;
    }

    public Endpoint getEndpoint(String uri) {
        return (Endpoint)this.map.get(uri);
    }

    public List<EndpointReference> getEndpointRefereneces() {
        return this.endpointreferences;
    }

    public List<Endpoint> getEndpoints() {
        return new ArrayList<Object>(this.map.values());
    }

    public List<EndpointListener> getListeners() {
        return this.listeners;
    }

    public void removeEndpoint(Endpoint endpoint) {
        this.map.remove(endpoint.getURI());
        logger.info("Remove endpoint - " + endpoint);
    }

    public void removeEndpointReference(EndpointReference endpointReference) {
        this.endpointreferences.remove(endpointReference);
        logger.fine("Remove endpoint reference - " + endpointReference);
    }

    public void removeListener(EndpointListener listener) {
        this.listeners.remove(listener);
    }

    public void replicate(boolean complete) {
        this.map.replicate(complete);
    }

    public void updateEndpoint(String uri, Endpoint endpoint) {
        Endpoint oldEndpoint = this.getEndpoint(uri);
        if (oldEndpoint == null) {
            throw new IllegalArgumentException("Endpoint is not found: " + uri);
        }
        this.map.put(endpoint.getURI(), endpoint);
    }

    @Override
    public void entryAdded(Object key, Object value) {
        AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)value;
        Endpoint newEp = (Endpoint)entry.getValue();
        if (!this.isLocal(entry)) {
            logger.info(String.valueOf(this.id) + " Remote endpoint added: " + entry.getValue());
            newEp.setRemote(true);
        }
        newEp.setExtensionPointRegistry(this.registry);
        for (EndpointListener listener : this.listeners) {
            listener.endpointAdded(newEp);
        }
    }

    @Override
    public void entryRemoved(Object key, Object value) {
        AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)value;
        if (!this.isLocal(entry)) {
            logger.info(String.valueOf(this.id) + " Remote endpoint removed: " + entry.getValue());
        }
        Endpoint oldEp = (Endpoint)entry.getValue();
        for (EndpointListener listener : this.listeners) {
            listener.endpointRemoved(oldEp);
        }
    }

    @Override
    public void entryUpdated(Object key, Object oldValue, Object newValue) {
        AbstractReplicatedMap.MapEntry oldEntry = (AbstractReplicatedMap.MapEntry)oldValue;
        AbstractReplicatedMap.MapEntry newEntry = (AbstractReplicatedMap.MapEntry)newValue;
        if (!this.isLocal(newEntry)) {
            logger.info(String.valueOf(this.id) + " Remote endpoint updated: " + newEntry.getValue());
        }
        Endpoint oldEp = (Endpoint)oldEntry.getValue();
        Endpoint newEp = (Endpoint)newEntry.getValue();
        for (EndpointListener listener : this.listeners) {
            listener.endpointUpdated(oldEp, newEp);
        }
    }

    public static void main(String[] args) throws Exception {
        GroupChannel channel = new GroupChannel();
        McastService mcastService = (McastService)channel.getMembershipService();
        mcastService.setPort(50000);
        mcastService.setAddress(MULTICAST_ADDRESS);
        InetAddress localhost = InetAddress.getLocalHost();
        mcastService.setBind(ReplicatedEndpointRegistry.getBindAddress());
        channel.start(15);
        ReplicatedMap map = new ReplicatedMap(null, (Channel)channel, 50L, "01", null);
        map.put(UUID.randomUUID().toString(), localhost.getHostAddress());
        int i = 0;
        while (i < 4) {
            Thread.sleep(3000L);
            System.out.println(localhost + ": " + map.keySet());
            ++i;
        }
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySetFull().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> e;
            Map.Entry<Object, Object> en = e = iterator.next();
            AbstractReplicatedMap.MapEntry entry = (AbstractReplicatedMap.MapEntry)en.getValue();
            System.out.println(entry);
        }
        map.breakdown();
        channel.stop(15);
    }

    /*
     * Unable to fully structure code
     */
    private static String getBindAddress() {
        try {
            nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                ni = nis.nextElement();
                ips = ni.getInetAddresses();
                if (ips.hasMoreElements()) ** GOTO lbl11
                continue;
lbl-1000:
                // 1 sources

                {
                    addr = ips.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    return addr.getHostAddress();
lbl11:
                    // 2 sources

                    ** while (ips.hasMoreElements())
                }
lbl12:
                // 1 sources

            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            ReplicatedEndpointRegistry.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

